/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.client.ExtensionAdapter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public final class Adapters {
    private static final Set<ClassLoader> CLASS_LOADERS = new HashSet<ClassLoader>();
    private static final Map<Class, ExtensionAdapter> EXTENSION_ADAPTER_MAP = new HashMap<Class, ExtensionAdapter>();

    private Adapters() {
    }

    public static <C> void register(ExtensionAdapter<C> adapter) {
        EXTENSION_ADAPTER_MAP.put(adapter.getExtensionType(), adapter);
    }

    public static <C> void unregister(ExtensionAdapter<C> adapter) {
        EXTENSION_ADAPTER_MAP.remove(adapter.getExtensionType());
    }

    public static <C> ExtensionAdapter<C> get(Class<C> type) {
        Adapters.discoverServices(type.getClassLoader());
        return EXTENSION_ADAPTER_MAP.get(type);
    }

    private static void discoverServices(ClassLoader classLoader) {
        if (CLASS_LOADERS.add(classLoader)) {
            for (ExtensionAdapter adapter : ServiceLoader.load(ExtensionAdapter.class, classLoader)) {
                Adapters.register(adapter);
            }
        }
    }

    static {
        Adapters.discoverServices(Adapters.class.getClassLoader());
    }
}

