/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.ws.WebSocket;
import com.squareup.okhttp.ws.WebSocketCall;
import com.squareup.okhttp.ws.WebSocketListener;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.WatchEvent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import okio.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchConnectionManager<T, L extends KubernetesResourceList>
implements Watch {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final AtomicBoolean forceClosed = new AtomicBoolean();
    private final AtomicReference<String> resourceVersion;
    private final BaseOperation<T, L, ?, ?> baseOperation;
    private final Watcher<T> watcher;
    private final int reconnectLimit;
    private final int reconnectInterval;
    private final AtomicInteger currentReconnectAttempt = new AtomicInteger(0);
    private final AtomicReference<WebSocket> webSocketRef = new AtomicReference();
    private WebSocketCall webSocketCall;
    private OkHttpClient clonedClient;

    public WatchConnectionManager(OkHttpClient client, BaseOperation<T, L, ?, ?> baseOperation, String version, Watcher<T> watcher, int reconnectInterval, int reconnectLimit) throws InterruptedException, ExecutionException, MalformedURLException {
        if (version == null) {
            L currentList = baseOperation.list();
            this.resourceVersion = new AtomicReference<String>(currentList.getMetadata().getResourceVersion());
        } else {
            this.resourceVersion = new AtomicReference<String>(version);
        }
        this.clonedClient = client.clone();
        this.baseOperation = baseOperation;
        this.watcher = watcher;
        this.reconnectInterval = reconnectInterval;
        this.reconnectLimit = reconnectLimit;
        this.runWatch();
    }

    private final void runWatch() throws MalformedURLException, ExecutionException, InterruptedException {
        URL requestUrl = this.baseOperation.getNamespacedUrl();
        HttpUrl.Builder httpUrlBuilder = HttpUrl.get(requestUrl).newBuilder();
        String labelQueryParam = this.baseOperation.getLabelQueryParam();
        if (labelQueryParam.length() > 0) {
            httpUrlBuilder.addQueryParameter("labelSelector", labelQueryParam);
        }
        String fieldQueryString = this.baseOperation.getFieldQueryParam();
        String name = this.baseOperation.getName();
        if (name != null && name.length() > 0) {
            if (fieldQueryString.length() > 0) {
                fieldQueryString = fieldQueryString + ",";
            }
            fieldQueryString = fieldQueryString + "metadata.name=" + name;
        }
        httpUrlBuilder.addQueryParameter("fieldSelector", fieldQueryString);
        httpUrlBuilder.addQueryParameter("resourceVersion", this.resourceVersion.get()).addQueryParameter("watch", "true");
        Request request = new Request.Builder().get().url(httpUrlBuilder.build()).addHeader("Origin", requestUrl.getProtocol() + "://" + requestUrl.getHost() + ":" + requestUrl.getPort()).build();
        this.clonedClient.setReadTimeout(0L, TimeUnit.MILLISECONDS);
        this.webSocketCall = WebSocketCall.create(this.clonedClient, request);
        this.webSocketCall.enqueue(new WebSocketListener(){
            private final Logger logger = LoggerFactory.getLogger(this.getClass());

            @Override
            public void onOpen(WebSocket webSocket, Response response) {
                WatchConnectionManager.this.webSocketRef.set(webSocket);
                WatchConnectionManager.this.currentReconnectAttempt.set(0);
            }

            @Override
            public void onFailure(IOException e, Response response) {
                if (!WatchConnectionManager.this.forceClosed.get()) {
                    if (response != null) {
                        try {
                            Status responseStatus = (Status)mapper.readValue(response.body().byteStream(), Status.class);
                            WatchConnectionManager.this.watcher.onClose(new KubernetesClientException("Connection unexpectedly closed", response.code(), responseStatus));
                            return;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    WatchConnectionManager.this.watcher.onClose(new KubernetesClientException("Connection unexpectedly closed", e));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessage(ResponseBody message) throws IOException {
                try {
                    WatchEvent event = (WatchEvent)mapper.readValue(message.byteStream(), WatchEvent.class);
                    HasMetadata obj = event.getObject();
                    String currentResourceVersion = (String)WatchConnectionManager.this.resourceVersion.get();
                    String newResourceVersion = obj.getMetadata().getResourceVersion();
                    if (currentResourceVersion.compareTo(newResourceVersion) < 0) {
                        WatchConnectionManager.this.resourceVersion.compareAndSet(currentResourceVersion, newResourceVersion);
                    }
                    Watcher.Action action = Watcher.Action.valueOf(event.getType());
                    WatchConnectionManager.this.watcher.eventReceived(action, obj);
                }
                catch (IOException e) {
                    this.logger.error("Could not deserialize watch event: {}", (Object)message.source().readUtf8(), (Object)e);
                }
                catch (ClassCastException e) {
                    this.logger.error("Received wrong type of object for watch", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    this.logger.error("Invalid event type", (Throwable)e);
                }
                finally {
                    message.close();
                }
            }

            @Override
            public void onPong(Buffer buffer) {
            }

            @Override
            public void onClose(int code, String reason) {
                block7: {
                    if (!WatchConnectionManager.this.forceClosed.get()) {
                        try {
                            WatchConnectionManager.this.runWatch();
                        }
                        catch (ExecutionException e) {
                            if (e.getCause() == null || e.getCause().getCause() == null || !(e.getCause().getCause() instanceof ConnectException)) break block7;
                            if (WatchConnectionManager.this.reconnectLimit >= 0 && WatchConnectionManager.this.currentReconnectAttempt.getAndIncrement() >= WatchConnectionManager.this.reconnectLimit) {
                                WatchConnectionManager.this.watcher.onClose(new KubernetesClientException("Connection unexpectedly closed", e));
                                return;
                            }
                            try {
                                TimeUnit.MILLISECONDS.sleep(WatchConnectionManager.this.reconnectInterval);
                            }
                            catch (InterruptedException e1) {
                                WatchConnectionManager.this.watcher.onClose(new KubernetesClientException("Connection unexpectedly closed", e1));
                                return;
                            }
                            this.onClose(code, reason);
                        }
                        catch (InterruptedException | MalformedURLException e) {
                            throw KubernetesClientException.launderThrowable(e);
                        }
                    }
                }
                WatchConnectionManager.this.watcher.onClose(null);
            }
        });
    }

    @Override
    public void close() {
        this.forceClosed.set(true);
        try {
            WebSocket ws = this.webSocketRef.get();
            if (ws != null) {
                ws.close(1000, "Closing...");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

