/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.ws.WebSocket;
import com.squareup.okhttp.ws.WebSocketListener;
import io.fabric8.kubernetes.client.Callback;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.utils.InputStreamPumper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import okio.Buffer;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecWebSocketListener
implements ExecWatch,
WebSocketListener,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecWebSocketListener.class);
    private final InputStream in;
    private final OutputStream out;
    private final OutputStream err;
    private final PipedOutputStream input;
    private final PipedInputStream output;
    private final PipedInputStream error;
    private final AtomicReference<WebSocket> webSocketRef = new AtomicReference();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final InputStreamPumper pumper;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue(1);
    private final ExecListener listener;

    public ExecWebSocketListener(InputStream in, OutputStream out, OutputStream err, PipedOutputStream inputPipe, PipedInputStream outputPipe, PipedInputStream errorPipe, ExecListener listener) {
        this.listener = listener;
        this.in = ExecWebSocketListener.inputStreamOrPipe(in, inputPipe);
        this.out = ExecWebSocketListener.outputStreamOrPipe(out, outputPipe);
        this.err = ExecWebSocketListener.outputStreamOrPipe(err, errorPipe);
        this.input = inputPipe;
        this.output = outputPipe;
        this.error = errorPipe;
        this.pumper = new InputStreamPumper(this.in, new Callback<byte[]>(){

            @Override
            public void call(byte[] data) {
                try {
                    ExecWebSocketListener.this.send(data);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void close() {
        this.pumper.close();
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
        WebSocket ws = this.webSocketRef.get();
        try {
            if (ws != null) {
                ws.close(1000, "Closing...");
            }
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    public void waitUntilReady() {
        try {
            Object obj = this.queue.poll(10L, TimeUnit.SECONDS);
            if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                return;
            }
            if (obj instanceof Throwable) {
                throw (Throwable)obj;
            }
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOpen(WebSocket webSocket, Response response) {
        try {
            if (this.in instanceof PipedInputStream && this.input != null) {
                this.input.connect((PipedInputStream)this.in);
            }
            if (this.out instanceof PipedOutputStream && this.output != null) {
                this.output.connect((PipedOutputStream)this.out);
            }
            if (this.err instanceof PipedOutputStream && this.error != null) {
                this.error.connect((PipedOutputStream)this.err);
            }
            this.webSocketRef.set(webSocket);
            this.executorService.submit(this.pumper);
            this.started.set(true);
            this.queue.add(true);
        }
        catch (IOException e) {
            this.queue.add(e);
        }
        finally {
            if (this.listener != null) {
                this.listener.onOpen(response);
            }
        }
    }

    @Override
    public void onFailure(IOException ioe, Response response) {
        try {
            LOGGER.error(response != null ? response.message() : "Exec Failure.", (Throwable)ioe);
            if (!this.started.get()) {
                this.queue.add(ioe);
            }
        }
        finally {
            if (this.listener != null) {
                this.listener.onFailure(ioe, response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onMessage(ResponseBody message) throws IOException {
        try {
            byte streamID = message.source().readByte();
            ByteString byteString = message.source().readByteString();
            if (byteString.size() <= 0) return;
            switch (streamID) {
                case 1: {
                    if (this.out == null) return;
                    this.out.write(byteString.toByteArray());
                    return;
                }
                case 2: {
                    if (this.err == null) return;
                    this.err.write(byteString.toByteArray());
                    return;
                }
                case 3: {
                    if (this.err == null) return;
                    this.err.write(byteString.toByteArray());
                    return;
                }
                default: {
                    throw new IOException("Unknown stream ID " + streamID);
                }
            }
        }
        finally {
            message.close();
        }
    }

    @Override
    public void onPong(Buffer buffer) {
        LOGGER.debug("Exec Web Socket: On Pong");
    }

    @Override
    public void onClose(int i, String s) {
        LOGGER.debug("Exec Web Socket: On Close");
        if (this.listener != null) {
            this.listener.onClose(i, s);
        }
    }

    @Override
    public OutputStream getInput() {
        return this.input;
    }

    @Override
    public InputStream getOutput() {
        return this.output;
    }

    @Override
    public InputStream getError() {
        return this.error;
    }

    private void send(byte[] bytes) throws IOException {
        WebSocket ws;
        if (bytes.length > 0 && (ws = this.webSocketRef.get()) != null) {
            byte[] toSend = new byte[bytes.length + 1];
            toSend[0] = 0;
            System.arraycopy(bytes, 0, toSend, 1, bytes.length);
            ws.sendMessage(RequestBody.create(WebSocket.BINARY, toSend));
        }
    }

    private static InputStream inputStreamOrPipe(InputStream stream, PipedOutputStream out) {
        if (stream != null) {
            return stream;
        }
        if (out != null) {
            return new PipedInputStream();
        }
        return null;
    }

    private static OutputStream outputStreamOrPipe(OutputStream stream, PipedInputStream in) {
        if (stream != null) {
            return stream;
        }
        if (in != null) {
            return new PipedOutputStream();
        }
        return null;
    }
}

