/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.ResourceHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public final class Handlers {
    private static final Map<String, ResourceHandler> RESOURCE_HANDLER_MAP = new HashMap<String, ResourceHandler>();

    private Handlers() {
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> void register(ResourceHandler<T, V> handler) {
        RESOURCE_HANDLER_MAP.put(handler.getKind().toLowerCase(), handler);
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> void unregister(ResourceHandler<T, V> handler) {
        RESOURCE_HANDLER_MAP.remove(handler.getKind().toLowerCase());
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> ResourceHandler<T, V> get(String kind) {
        return RESOURCE_HANDLER_MAP.get(kind.toLowerCase());
    }

    static {
        for (ResourceHandler handler : ServiceLoader.load(ResourceHandler.class)) {
            Handlers.register(handler);
        }
    }
}

