/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.client.internal.PKCS1Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import okio.ByteString;

public class CertUtils {
    public static InputStream getInputStreamFromDataOrFile(String data, String file) throws FileNotFoundException {
        if (data != null) {
            return new ByteArrayInputStream(ByteString.decodeBase64(data).toByteArray());
        }
        if (file != null) {
            return new FileInputStream(file);
        }
        return null;
    }

    public static KeyStore createTrustStore(String caCertData, String caCertFile) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try (InputStream pemInputStream = CertUtils.getInputStreamFromDataOrFile(caCertData, caCertFile);){
            KeyStore keyStore = CertUtils.createTrustStore(pemInputStream);
            return keyStore;
        }
    }

    public static KeyStore createTrustStore(InputStream pemInputStream) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X509");
        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(pemInputStream);
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(null);
        String alias = cert.getSubjectX500Principal().getName();
        trustStore.setCertificateEntry(alias, cert);
        return trustStore;
    }

    public static KeyStore createKeyStore(InputStream certInputStream, InputStream keyInputStream, String clientKeyAlgo, char[] clientKeyPassphrase) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        PrivateKey privateKey;
        CertificateFactory certFactory = CertificateFactory.getInstance("X509");
        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(certInputStream);
        byte[] keyBytes = CertUtils.decodePem(keyInputStream);
        KeyFactory keyFactory = KeyFactory.getInstance(clientKeyAlgo);
        try {
            privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyBytes));
        }
        catch (InvalidKeySpecException e) {
            RSAPrivateCrtKeySpec keySpec = PKCS1Util.decodePKCS1(keyBytes);
            privateKey = keyFactory.generatePrivate(keySpec);
        }
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, clientKeyPassphrase);
        String alias = cert.getSubjectX500Principal().getName();
        keyStore.setKeyEntry(alias, privateKey, clientKeyPassphrase, new Certificate[]{cert});
        return keyStore;
    }

    /*
     * Exception decompiling
     */
    public static KeyStore createKeyStore(String clientCertData, String clientCertFile, String clientKeyData, String clientKeyFile, String clientKeyAlgo, char[] clientKeyPassphrase) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static byte[] decodePem(InputStream keyInputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(keyInputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("-----BEGIN ")) continue;
                byte[] byArray = CertUtils.readBytes(reader, line.trim().replace("BEGIN", "END"));
                return byArray;
            }
            throw new IOException("PEM is invalid: no begin marker");
        }
    }

    private static byte[] readBytes(BufferedReader reader, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(endMarker) != -1) {
                return ByteString.decodeBase64(buf.toString()).toByteArray();
            }
            buf.append(line.trim());
        }
        throw new IOException("PEM is invalid : No end marker");
    }
}

