/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ws.WebSocketCall;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecOutputErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecable;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.ExecWebSocketListener;
import io.fabric8.kubernetes.client.utils.URLUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.util.concurrent.TimeUnit;

public class PodOperationsImpl
extends HasMetadataOperation<Pod, PodList, DoneablePod, ClientPodResource<Pod, DoneablePod>>
implements ClientPodResource<Pod, DoneablePod> {
    private static final String[] EMPTY_COMMAND = new String[]{"/bin/sh", "-i"};
    private final String containerId;
    private final InputStream in;
    private final OutputStream out;
    private final OutputStream err;
    private final PipedOutputStream inPipe;
    private final PipedInputStream outPipe;
    private final PipedInputStream errPipe;
    private final boolean withTTY;

    public PodOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(client, config, null, namespace, null, true, null);
    }

    public PodOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, Pod item) {
        this(client, config, apiVersion, namespace, name, cascading, item, null, null, null, null, null, null, null, false);
    }

    public PodOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, Pod item, String containerId, InputStream in, PipedOutputStream inPipe, OutputStream out, PipedInputStream outPipe, OutputStream err, PipedInputStream errPipe, boolean withTTY) {
        super(client, config, null, apiVersion, "pods", namespace, name, cascading, item);
        this.containerId = containerId;
        this.in = in;
        this.inPipe = inPipe;
        this.out = out;
        this.outPipe = outPipe;
        this.err = err;
        this.errPipe = errPipe;
        this.withTTY = withTTY;
    }

    @Override
    public String getLog() {
        return this.getLog(true);
    }

    @Override
    public String getLog(Boolean isPretty) {
        StringBuilder sb = new StringBuilder();
        sb.append("log?pretty=").append(isPretty);
        if (this.containerId != null && !this.containerId.isEmpty()) {
            sb.append("&container=").append(this.containerId);
        }
        try {
            URL url = new URL(URLUtils.join(this.getResourceUrl().toString(), sb.toString()));
            Request.Builder requestBuilder = new Request.Builder().get().url(url);
            Request request = requestBuilder.build();
            Response response = this.client.newCall(request).execute();
            this.assertResponseCode(request, response, 200);
            return response.body().string();
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public String getLog(String containerId) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), containerId, this.in, this.inPipe, this.out, this.outPipe, this.err, this.errPipe, this.withTTY).getLog(true);
    }

    @Override
    public String getLog(String containerId, Boolean isPretty) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), containerId, this.in, this.inPipe, this.out, this.outPipe, this.err, this.errPipe, this.withTTY).getLog(isPretty);
    }

    @Override
    public ContainerResource<String, InputStream, PipedOutputStream, OutputStream, PipedInputStream, String, ExecWatch> inContainer(String containerId) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), containerId, this.in, this.inPipe, this.out, this.outPipe, this.err, this.errPipe, this.withTTY);
    }

    public ExecWatch exec(String ... command) {
        StringBuilder sb = new StringBuilder();
        String[] actualCommands = command.length >= 1 ? command : EMPTY_COMMAND;
        sb.append("exec?command=");
        boolean first = true;
        for (String cmd : actualCommands) {
            if (first) {
                first = false;
            } else {
                sb.append("&command=");
            }
            sb.append(cmd);
        }
        if (this.containerId != null && !this.containerId.isEmpty()) {
            sb.append("&container=").append(this.containerId);
        }
        if (this.withTTY) {
            sb.append("&tty=true");
        }
        if (this.in != null || this.inPipe != null) {
            sb.append("&stdin=true");
        }
        if (this.out != null || this.outPipe != null) {
            sb.append("&stdout=true");
        }
        if (this.err != null || this.errPipe != null) {
            sb.append("&stderr=true");
        }
        try {
            URL url = new URL(URLUtils.join(this.getResourceUrl().toString(), sb.toString()));
            Request.Builder r = new Request.Builder().url(url).get();
            OkHttpClient clone = this.client.clone();
            clone.setReadTimeout(0L, TimeUnit.MILLISECONDS);
            WebSocketCall webSocketCall = WebSocketCall.create(clone, r.build());
            ExecWebSocketListener execWebSocketListener = new ExecWebSocketListener(this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe);
            webSocketCall.enqueue(execWebSocketListener);
            execWebSocketListener.waitUntilReady();
            return execWebSocketListener;
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public TtyExecOutputErrorable<String, OutputStream, PipedInputStream, ExecWatch> readingInput(InputStream in) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.containerId, in, this.inPipe, this.out, this.outPipe, this.err, this.errPipe, this.withTTY);
    }

    @Override
    public TtyExecOutputErrorable<String, OutputStream, PipedInputStream, ExecWatch> writingInput(PipedOutputStream inPipe) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.containerId, this.in, inPipe, this.out, this.outPipe, this.err, this.errPipe, this.withTTY);
    }

    @Override
    public TtyExecOutputErrorable<String, OutputStream, PipedInputStream, ExecWatch> redirectingInput() {
        return this.writingInput(new PipedOutputStream());
    }

    @Override
    public TtyExecErrorable<String, OutputStream, PipedInputStream, ExecWatch> writingOutput(OutputStream out) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.containerId, this.in, this.inPipe, out, this.outPipe, this.err, this.errPipe, this.withTTY);
    }

    @Override
    public TtyExecErrorable<String, OutputStream, PipedInputStream, ExecWatch> readingOutput(PipedInputStream outPipe) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.containerId, this.in, this.inPipe, this.out, outPipe, this.err, this.errPipe, this.withTTY);
    }

    @Override
    public TtyExecErrorable<String, OutputStream, PipedInputStream, ExecWatch> redirectingOutput() {
        return this.readingOutput(new PipedInputStream());
    }

    @Override
    public TtyExecable<String, ExecWatch> writingError(OutputStream err) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.containerId, this.in, this.inPipe, this.out, this.outPipe, err, this.errPipe, this.withTTY);
    }

    @Override
    public TtyExecable<String, ExecWatch> readingError(PipedInputStream errPipe) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.containerId, this.in, this.inPipe, this.out, this.outPipe, this.err, errPipe, this.withTTY);
    }

    @Override
    public TtyExecable<String, ExecWatch> redirectingError() {
        return this.readingError(new PipedInputStream());
    }

    @Override
    public Execable<String, ExecWatch> withTTY() {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.containerId, this.in, this.inPipe, this.out, this.outPipe, this.err, this.errPipe, true);
    }
}

