/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.ws;

import com.squareup.okhttp.internal.ws.WebSocketProtocol;
import com.squareup.okhttp.ws.WebSocket;
import java.io.IOException;
import java.util.Random;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Timeout;

public final class WebSocketWriter {
    private final boolean isClient;
    private final BufferedSink sink;
    private final Random random;
    private final FrameSink frameSink = new FrameSink();
    private boolean closed;
    private boolean activeWriter;
    private final byte[] maskKey;
    private final byte[] maskBuffer;

    public WebSocketWriter(boolean isClient, BufferedSink sink, Random random) {
        if (sink == null) {
            throw new NullPointerException("sink == null");
        }
        if (random == null) {
            throw new NullPointerException("random == null");
        }
        this.isClient = isClient;
        this.sink = sink;
        this.random = random;
        this.maskKey = isClient ? new byte[4] : null;
        this.maskBuffer = isClient ? new byte[2048] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePing(Buffer payload) throws IOException {
        BufferedSink bufferedSink = this.sink;
        synchronized (bufferedSink) {
            this.writeControlFrame(9, payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePong(Buffer payload) throws IOException {
        BufferedSink bufferedSink = this.sink;
        synchronized (bufferedSink) {
            this.writeControlFrame(10, payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeClose(int code, String reason) throws IOException {
        Buffer payload = null;
        if (code != 0 || reason != null) {
            if (code != 0 && (code < 1000 || code >= 5000)) {
                throw new IllegalArgumentException("Code must be in range [1000,5000).");
            }
            payload = new Buffer();
            payload.writeShort(code);
            if (reason != null) {
                payload.writeUtf8(reason);
            }
        }
        BufferedSink bufferedSink = this.sink;
        synchronized (bufferedSink) {
            this.writeControlFrame(8, payload);
            this.closed = true;
        }
    }

    private void writeControlFrame(int opcode, Buffer payload) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        int length = 0;
        if (payload != null && (length = (int)payload.size()) > 125) {
            throw new IllegalArgumentException("Payload size must be less than or equal to 125");
        }
        int b0 = 0x80 | opcode;
        this.sink.writeByte(b0);
        int b1 = length;
        if (this.isClient) {
            this.sink.writeByte(b1 |= 0x80);
            this.random.nextBytes(this.maskKey);
            this.sink.write(this.maskKey);
            if (payload != null) {
                this.writeAllMasked(payload, length);
            }
        } else {
            this.sink.writeByte(b1);
            if (payload != null) {
                this.sink.writeAll(payload);
            }
        }
        this.sink.flush();
    }

    public BufferedSink newMessageSink(WebSocket.PayloadType type) {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        if (this.activeWriter) {
            throw new IllegalStateException("Another message writer is active. Did you call close()?");
        }
        this.activeWriter = true;
        this.frameSink.payloadType = type;
        this.frameSink.isFirstFrame = true;
        return Okio.buffer(this.frameSink);
    }

    public void sendMessage(WebSocket.PayloadType type, Buffer payload) throws IOException {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        if (payload == null) {
            throw new NullPointerException("payload == null");
        }
        if (this.activeWriter) {
            throw new IllegalStateException("A message writer is active. Did you call close()?");
        }
        this.writeFrame(type, payload, payload.size(), true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFrame(WebSocket.PayloadType payloadType, Buffer source, long byteCount, boolean isFirstFrame, boolean isFinal) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        int opcode = 0;
        if (isFirstFrame) {
            switch (payloadType) {
                case TEXT: {
                    opcode = 1;
                    break;
                }
                case BINARY: {
                    opcode = 2;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown payload type: " + (Object)((Object)payloadType));
                }
            }
        }
        BufferedSink bufferedSink = this.sink;
        synchronized (bufferedSink) {
            int b0 = opcode;
            if (isFinal) {
                b0 |= 0x80;
            }
            this.sink.writeByte(b0);
            int b1 = 0;
            if (this.isClient) {
                b1 |= 0x80;
                this.random.nextBytes(this.maskKey);
            }
            if (byteCount <= 125L) {
                this.sink.writeByte(b1 |= (int)byteCount);
            } else if (byteCount <= 65535L) {
                this.sink.writeByte(b1 |= 0x7E);
                this.sink.writeShort((int)byteCount);
            } else {
                this.sink.writeByte(b1 |= 0x7F);
                this.sink.writeLong(byteCount);
            }
            if (this.isClient) {
                this.sink.write(this.maskKey);
                this.writeAllMasked(source, byteCount);
            } else {
                this.sink.write(source, byteCount);
            }
            this.sink.flush();
        }
    }

    private void writeAllMasked(BufferedSource source, long byteCount) throws IOException {
        int read;
        for (long written = 0L; written < byteCount; written += (long)read) {
            int toRead = (int)Math.min(byteCount, (long)this.maskBuffer.length);
            read = source.read(this.maskBuffer, 0, toRead);
            if (read == -1) {
                throw new AssertionError();
            }
            WebSocketProtocol.toggleMask(this.maskBuffer, read, this.maskKey, written);
            this.sink.write(this.maskBuffer, 0, read);
        }
    }

    private final class FrameSink
    implements Sink {
        private WebSocket.PayloadType payloadType;
        private boolean isFirstFrame;

        private FrameSink() {
        }

        @Override
        public void write(Buffer source, long byteCount) throws IOException {
            WebSocketWriter.this.writeFrame(this.payloadType, source, byteCount, this.isFirstFrame, false);
            this.isFirstFrame = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            if (WebSocketWriter.this.closed) {
                throw new IOException("closed");
            }
            BufferedSink bufferedSink = WebSocketWriter.this.sink;
            synchronized (bufferedSink) {
                WebSocketWriter.this.sink.flush();
            }
        }

        @Override
        public Timeout timeout() {
            return WebSocketWriter.this.sink.timeout();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (WebSocketWriter.this.closed) {
                throw new IOException("closed");
            }
            int length = 0;
            BufferedSink bufferedSink = WebSocketWriter.this.sink;
            synchronized (bufferedSink) {
                WebSocketWriter.this.sink.writeByte(128);
                if (WebSocketWriter.this.isClient) {
                    WebSocketWriter.this.sink.writeByte(0x80 | length);
                    WebSocketWriter.this.random.nextBytes(WebSocketWriter.this.maskKey);
                    WebSocketWriter.this.sink.write(WebSocketWriter.this.maskKey);
                } else {
                    WebSocketWriter.this.sink.writeByte(length);
                }
                WebSocketWriter.this.sink.flush();
            }
            WebSocketWriter.this.activeWriter = false;
        }
    }
}

