/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.server.mock;

import com.google.mockwebserver.Dispatcher;
import com.google.mockwebserver.MockResponse;
import com.google.mockwebserver.MockWebServer;
import com.google.mockwebserver.RecordedRequest;
import io.fabric8.kubernetes.api.model.RootPathsBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.EditableConfig;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.server.mock.MockSSLContextFactory;
import io.fabric8.kubernetes.server.mock.MockServerExpectation;
import io.fabric8.kubernetes.server.mock.MockServerExpectationImpl;
import io.fabric8.kubernetes.server.mock.Pathable;
import io.fabric8.kubernetes.server.mock.Returnable;
import io.fabric8.kubernetes.server.mock.ServerRequest;
import io.fabric8.kubernetes.server.mock.ServerResponse;
import io.fabric8.kubernetes.server.mock.Timeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

public class KubernetesMockServer {
    private final boolean useHttps;
    private MockWebServer server = new MockWebServer();
    private Map<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();

    public KubernetesMockServer() {
        this(true);
    }

    public KubernetesMockServer(boolean useHttps) {
        this.useHttps = useHttps;
    }

    public void init() {
        try {
            if (this.useHttps) {
                this.server.useHttps(MockSSLContextFactory.create().getSocketFactory(), false);
            }
            this.server.setDispatcher(new Dispatcher(){

                public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
                    String method = request.getMethod();
                    String path = request.getPath();
                    ServerRequest key = new ServerRequest(method, path);
                    ServerRequest keyForAnyMethod = new ServerRequest(path);
                    if (KubernetesMockServer.this.responses.containsKey(key)) {
                        Queue queue = (Queue)KubernetesMockServer.this.responses.get(key);
                        return KubernetesMockServer.this.handleResponse((ServerResponse)queue.peek(), queue);
                    }
                    if (KubernetesMockServer.this.responses.containsKey(keyForAnyMethod)) {
                        Queue queue = (Queue)KubernetesMockServer.this.responses.get(keyForAnyMethod);
                        return KubernetesMockServer.this.handleResponse((ServerResponse)queue.peek(), queue);
                    }
                    return new MockResponse().setResponseCode(404);
                }
            });
            ((Timeable)((Returnable)((Pathable)this.expect().get()).withPath("/")).andReturn(200, ((RootPathsBuilder)new RootPathsBuilder().addToPaths(new String[]{"/api"})).build())).always();
            this.server.play();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private MockResponse handleResponse(ServerResponse response, Queue<ServerResponse> queue) {
        if (response == null) {
            return new MockResponse().setResponseCode(404);
        }
        if (response.isToBeRemoved()) {
            queue.remove();
        }
        MockResponse mockResponse = new MockResponse();
        mockResponse.setBody(response.getBody());
        mockResponse.setResponseCode(response.getCode());
        return mockResponse;
    }

    public void destroy() throws IOException {
        this.server.shutdown();
    }

    public KubernetesClient createClient() {
        EditableConfig config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(this.server.getUrl("/").toString())).withTrustCerts(true)).withNamespace("test")).build();
        return new DefaultKubernetesClient((Config)config);
    }

    public MockWebServer getServer() {
        return this.server;
    }

    public MockServerExpectation expect() {
        return new MockServerExpectationImpl(this.responses);
    }
}

