/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import io.fabric8.kubernetes.api.model.EditablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientLoggableResource;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.mock.KubernetesMockServerTestBase;
import io.fabric8.kubernetes.server.mock.Returnable;
import io.fabric8.kubernetes.server.mock.Timeable;
import org.junit.Assert;
import org.junit.Test;

public class PodTest
extends KubernetesMockServerTestBase {
    @Test
    public void testList() {
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/namespaces/test/pods")).andReturn(200, new PodListBuilder().build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/namespaces/ns1/pods")).andReturn(200, ((PodListBuilder)((PodListBuilder)new PodListBuilder().addNewItem().and()).addNewItem().and()).build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/pods")).andReturn(200, ((PodListBuilder)((PodListBuilder)((PodListBuilder)new PodListBuilder().addNewItem().and()).addNewItem().and()).addNewItem().and()).build())).once();
        KubernetesClient client = this.getClient();
        PodList podList = (PodList)client.pods().list();
        Assert.assertNotNull((Object)podList);
        Assert.assertEquals((long)0L, (long)podList.getItems().size());
        podList = (PodList)((ClientNonNamespaceOperation)client.pods().inNamespace("ns1")).list();
        Assert.assertNotNull((Object)podList);
        Assert.assertEquals((long)2L, (long)podList.getItems().size());
        podList = (PodList)((FilterWatchListMultiDeletable)client.pods().inAnyNamespace()).list();
        Assert.assertNotNull((Object)podList);
        Assert.assertEquals((long)3L, (long)podList.getItems().size());
    }

    @Test
    public void testListWithLables() {
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/namespaces/test/pods?labelSelector=" + PodTest.toUrlEncoded("key1=value1,key2=value2,key3=value3"))).andReturn(200, new PodListBuilder().build())).always();
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/namespaces/test/pods?labelSelector=" + PodTest.toUrlEncoded("key1=value1,key2=value2"))).andReturn(200, ((PodListBuilder)((PodListBuilder)((PodListBuilder)new PodListBuilder().addNewItem().and()).addNewItem().and()).addNewItem().and()).build())).once();
        KubernetesClient client = this.getClient();
        PodList podList = (PodList)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)client.pods().withLabel("key1", "value1")).withLabel("key2", "value2")).withLabel("key3", "value3")).list();
        Assert.assertNotNull((Object)podList);
        Assert.assertEquals((long)0L, (long)podList.getItems().size());
        podList = (PodList)((FilterWatchListDeletable)((FilterWatchListDeletable)client.pods().withLabel("key1", "value1")).withLabel("key2", "value2")).list();
        Assert.assertNotNull((Object)podList);
        Assert.assertEquals((long)3L, (long)podList.getItems().size());
    }

    @Test
    public void testGet() {
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/namespaces/test/pods/pod1")).andReturn(200, new PodBuilder().build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/namespaces/ns1/pods/pod2")).andReturn(200, new PodBuilder().build())).once();
        KubernetesClient client = this.getClient();
        Pod pod = (Pod)((ClientLoggableResource)client.pods().withName("pod1")).get();
        Assert.assertNotNull((Object)pod);
        pod = (Pod)((ClientLoggableResource)client.pods().withName("pod2")).get();
        Assert.assertNull((Object)pod);
        pod = (Pod)((ClientLoggableResource)((ClientNonNamespaceOperation)client.pods().inNamespace("ns1")).withName("pod2")).get();
        Assert.assertNotNull((Object)pod);
    }

    @Test
    public void testDelete() {
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/namespaces/test/pods/pod1")).andReturn(200, new PodBuilder().build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/namespaces/ns1/pods/pod2")).andReturn(200, new PodBuilder().build())).once();
        KubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((ClientLoggableResource)client.pods().withName("pod1")).delete();
        Assert.assertNotNull((Object)deleted);
        deleted = (Boolean)((ClientLoggableResource)client.pods().withName("pod2")).delete();
        Assert.assertFalse((boolean)deleted);
        deleted = (Boolean)((ClientLoggableResource)((ClientNonNamespaceOperation)client.pods().inNamespace("ns1")).withName("pod2")).delete();
        Assert.assertTrue((boolean)deleted);
    }

    @Test
    public void testDeleteMulti() {
        EditablePod pod1 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).and()).build();
        EditablePod pod2 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod2")).withNamespace("ns1")).and()).build();
        EditablePod pod3 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod3")).withNamespace("any")).and()).build();
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/namespaces/test/pods/pod1")).andReturn(200, pod1)).once();
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/namespaces/ns1/pods/pod2")).andReturn(200, pod2)).once();
        KubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((FilterWatchListMultiDeletable)client.pods().inAnyNamespace()).delete((Object[])new Pod[]{pod1, pod2});
        Assert.assertNotNull((Object)deleted);
        deleted = (Boolean)((FilterWatchListMultiDeletable)client.pods().inAnyNamespace()).delete((Object[])new Pod[]{pod3});
        Assert.assertFalse((boolean)deleted);
    }

    @Test(expected=KubernetesClientException.class)
    public void testDeleteWithNamespaceMismatch() {
        EditablePod pod1 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).and()).build();
        EditablePod pod2 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod2")).withNamespace("ns1")).and()).build();
        KubernetesClient client = this.getClient();
        Boolean deleted = (Boolean)((ClientNonNamespaceOperation)client.pods().inNamespace("test1")).delete((Object[])new Pod[]{pod1});
        Assert.assertNotNull((Object)deleted);
    }

    @Test(expected=KubernetesClientException.class)
    public void testCreateWithNameMismatch() {
        EditablePod pod1 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).and()).build();
        EditablePod pod2 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod2")).withNamespace("ns1")).and()).build();
        KubernetesClient client = this.getClient();
        ((ClientLoggableResource)((ClientNonNamespaceOperation)client.pods().inNamespace("test1")).withName("mypod1")).create((Object[])new Pod[]{pod1});
    }

    @Test
    public void testGetLog() {
        String pod1Log = "pod1Log";
        String pod2Log = "pod2Log";
        String pod3Log = "pod3Log";
        String pod4Log = "pod4Log";
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/namespaces/test/pods/pod1/log?pretty=true")).andReturn(200, pod1Log)).once();
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/namespaces/test/pods/pod2/log?pretty=false")).andReturn(200, pod2Log)).once();
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/namespaces/test/pods/pod3/log?pretty=false&container=cnt3")).andReturn(200, pod3Log)).once();
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/namespaces/test4/pods/pod4/log?pretty=true&container=cnt4")).andReturn(200, pod4Log)).once();
        KubernetesClient client = this.getClient();
        String log = (String)((ClientLoggableResource)client.pods().withName("pod1")).getLog(Boolean.valueOf(true));
        Assert.assertEquals((Object)pod1Log, (Object)log);
        log = (String)((ClientLoggableResource)client.pods().withName("pod2")).getLog(Boolean.valueOf(false));
        Assert.assertEquals((Object)pod2Log, (Object)log);
        log = (String)((ClientLoggableResource)client.pods().withName("pod3")).getLog("cnt3", Boolean.valueOf(false));
        Assert.assertEquals((Object)pod3Log, (Object)log);
        log = (String)((ClientLoggableResource)((ClientNonNamespaceOperation)client.pods().inNamespace("test4")).withName("pod4")).getLog("cnt4", Boolean.valueOf(true));
        Assert.assertEquals((Object)pod4Log, (Object)log);
    }

    @Test(expected=KubernetesClientException.class)
    public void testGetLogNotFound() {
        KubernetesClient client = this.getClient();
        ((ClientLoggableResource)client.pods().withName("pod5")).getLog(Boolean.valueOf(true));
    }

    private static final String toUrlEncoded(String str) {
        return str.replaceAll("=", "%3D");
    }
}

