/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientKubernetesListNonNamespaceOperation;
import io.fabric8.kubernetes.client.mock.KubernetesMockServerTestBase;
import org.junit.Assert;
import org.junit.Test;

public class KubernetesListTest
extends KubernetesMockServerTestBase {
    Pod pod1 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).and()).build();
    Service service1 = ((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("service1")).withNamespace("test")).and()).build();
    ReplicationController replicationController1 = ((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl1")).withNamespace("test")).and()).build();
    KubernetesList list = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(new HasMetadata[]{this.pod1, this.service1, this.replicationController1})).build();

    @Test
    public void testCreate() {
        this.expectAndReturnAsJson("/api/v1/namespaces/test/pods", 201, this.pod1);
        this.expectAndReturnAsJson("/api/v1/namespaces/test/services", 201, this.service1);
        this.expectAndReturnAsJson("/api/v1/namespaces/test/replicationcontrollers", 201, this.replicationController1);
        KubernetesClient client = this.getClient();
        KubernetesList result = (KubernetesList)((ClientKubernetesListNonNamespaceOperation)client.lists().inNamespace("test")).create((Object[])new KubernetesList[]{this.list});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)3L, (long)result.getItems().size());
        Assert.assertTrue((boolean)result.getItems().contains(this.pod1));
        Assert.assertTrue((boolean)result.getItems().contains(this.service1));
        Assert.assertTrue((boolean)result.getItems().contains(this.replicationController1));
    }

    @Test
    public void testDelete() {
        this.expectAndReturnAsJson("/api/v1/namespaces/test/pods/pod1", 200, this.pod1);
        this.expectAndReturnAsJson("/api/v1/namespaces/test/services/service1", 200, this.service1);
        this.expectAndReturnAsJson("/api/v1/namespaces/test/replicationcontrollers/repl1", 200, this.replicationController1);
        KubernetesClient client = this.getClient();
        Boolean result = (Boolean)client.lists().delete((Object[])new KubernetesList[]{this.list});
        Assert.assertTrue((boolean)result);
    }

    @Test(expected=KubernetesClientException.class)
    public void testDeleteWithMismatch() {
        KubernetesClient client = this.getClient();
        Boolean result = (Boolean)((ClientKubernetesListNonNamespaceOperation)client.lists().inNamespace("test1")).delete((Object[])new KubernetesList[]{this.list});
        Assert.assertTrue((boolean)result);
    }
}

