/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.server.mock;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.mockwebserver.Dispatcher;
import com.google.mockwebserver.MockResponse;
import com.google.mockwebserver.MockWebServer;
import com.google.mockwebserver.RecordedRequest;
import io.fabric8.kubernetes.api.model.RootPathsBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.EditableConfig;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.server.mock.ServerResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class KubernetesMockServer {
    private final ObjectMapper mapper = new ObjectMapper();
    private MockWebServer server = new MockWebServer();
    private Map<String, ServerResponse> responses = new HashMap<String, ServerResponse>();

    public void init() throws IOException {
        this.server.setDispatcher(new Dispatcher(){

            public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
                String path = request.getPath();
                if (KubernetesMockServer.this.responses.containsKey(path)) {
                    ServerResponse response = (ServerResponse)KubernetesMockServer.this.responses.get(path);
                    MockResponse mockResponse = new MockResponse();
                    mockResponse.setBody(response.getBody());
                    mockResponse.setResponseCode(response.getCode());
                    return mockResponse;
                }
                return new MockResponse().setResponseCode(404);
            }
        });
        this.expectAndReturnAsJson("/", 200, ((RootPathsBuilder)new RootPathsBuilder().addToPaths(new String[]{"/api"})).build());
        this.server.play();
    }

    public void destroy() throws IOException {
        this.server.shutdown();
    }

    public KubernetesClient createClient() {
        EditableConfig config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("http://localhost:" + this.server.getPort())).withNamespace("test")).build();
        return new DefaultKubernetesClient((Config)config);
    }

    public MockWebServer getServer() {
        return this.server;
    }

    public <T> void expectAndReturnAsJson(String path, int code, T body) {
        this.responses.put(path, new ServerResponse(code, this.toJson(body)));
    }

    public void expectAndReturnAsString(String path, int code, String body) {
        this.responses.put(path, new ServerResponse(code, body));
    }

    private String toJson(Object obj) {
        try {
            return this.mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

