/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.EditableConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConfigTest {
    @Before
    public void setUp() {
        System.getProperties().remove("kubernetes.master");
        System.getProperties().remove("kubernetes.namespace");
        System.getProperties().remove("kubernetes.auth.token");
        System.getProperties().remove("kubernetes.auth.basic.username");
        System.getProperties().remove("kubernetes.auth.basic.password");
        System.getProperties().remove("kubernetes.trust.certificates");
        System.getProperties().remove("kubernetes.certs.ca.file");
        System.getProperties().remove("kubernetes.certs.ca.data");
        System.getProperties().remove("kubernetes.certs.client.file");
        System.getProperties().remove("kubernetes.certs.client.data");
        System.getProperties().remove("kubernetes.certs.client.key.file");
        System.getProperties().remove("kubernetes.certs.client.key.data");
        System.getProperties().remove("kubernetes.certs.client.key.algo");
        System.getProperties().remove("kubernetes.certs.client.key.passphrase");
        System.getProperties().remove("kubernetes.certs.client.key.file");
        System.getProperties().remove("kubernetes.watch.reconnectInterval");
        System.getProperties().remove("kubernetes.watch.reconnectLimit");
        System.getProperties().remove("kubernetes.request.timeout");
        System.getProperties().remove("http.proxy");
    }

    @After
    public void tearDown() {
        this.setUp();
    }

    @Test
    public void testWithSystemProperties() {
        System.setProperty("kubernetes.master", "http://somehost:80");
        System.setProperty("kubernetes.namespace", "testns");
        System.setProperty("kubernetes.auth.token", "token");
        System.setProperty("kubernetes.auth.basic.username", "user");
        System.setProperty("kubernetes.auth.basic.password", "pass");
        System.setProperty("kubernetes.trust.certificates", "true");
        System.setProperty("kubernetes.certs.ca.file", "/path/to/cert");
        System.setProperty("kubernetes.certs.ca.data", "cacertdata");
        System.setProperty("kubernetes.certs.client.file", "/path/to/clientcert");
        System.setProperty("kubernetes.certs.client.data", "clientcertdata");
        System.setProperty("kubernetes.certs.client.key.file", "/path/to/clientkey");
        System.setProperty("kubernetes.certs.client.key.data", "clientkeydata");
        System.setProperty("kubernetes.certs.client.key.algo", "algo");
        System.setProperty("kubernetes.certs.client.key.passphrase", "passphrase");
        System.setProperty("kubernetes.certs.client.key.file", "/path/to/clientkey");
        System.setProperty("kubernetes.watch.reconnectInterval", "5000");
        System.setProperty("kubernetes.watch.reconnectLimit", "5");
        System.setProperty("kubernetes.request.timeout", "5000");
        System.setProperty("http.proxy", "httpProxy");
        Config config = new Config();
        this.assertConfig(config);
        config = new ConfigBuilder().build();
        this.assertConfig(config);
    }

    @Test
    public void testWithBuilder() {
        EditableConfig config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("http://somehost:80")).withApiVersion("v1")).withNamespace("testns")).withOauthToken("token")).withUsername("user")).withPassword("pass")).withTrustCerts(true)).withCaCertFile("/path/to/cert")).withCaCertData("cacertdata")).withClientCertFile("/path/to/clientcert")).withClientCertData("clientcertdata")).withClientKeyFile("/path/to/clientkey")).withClientKeyData("clientkeydata")).withClientKeyAlgo("algo")).withClientKeyPassphrase("passphrase")).withWatchReconnectInterval(5000)).withWatchReconnectLimit(5)).withRequestTimeout(5000)).withProxy("httpProxy")).build();
        this.assertConfig((Config)config);
    }

    @Test
    public void testWithBuilderAndSystemProperties() {
        System.setProperty("kubernetes.master", "http://tobeoverriden:80");
        System.setProperty("kubernetes.namespace", "tobeoverriden");
        System.setProperty("kubernetes.auth.token", "token");
        System.setProperty("kubernetes.auth.basic.username", "user");
        System.setProperty("kubernetes.auth.basic.password", "pass");
        System.setProperty("kubernetes.trust.certificates", "true");
        System.setProperty("kubernetes.certs.ca.file", "/path/to/cert");
        System.setProperty("kubernetes.certs.ca.data", "cacertdata");
        System.setProperty("kubernetes.certs.client.file", "/path/to/clientcert");
        System.setProperty("kubernetes.certs.client.data", "clientcertdata");
        System.setProperty("kubernetes.certs.client.key.file", "/path/to/clientkey");
        System.setProperty("kubernetes.certs.client.key.data", "clientkeydata");
        System.setProperty("kubernetes.certs.client.key.algo", "algo");
        System.setProperty("kubernetes.certs.client.key.passphrase", "passphrase");
        System.setProperty("kubernetes.certs.client.key.file", "/path/to/clientkey");
        System.setProperty("kubernetes.watch.reconnectInterval", "5000");
        System.setProperty("kubernetes.watch.reconnectLimit", "5");
        System.setProperty("kubernetes.request.timeout", "5000");
        System.setProperty("http.proxy", "httpProxy");
        EditableConfig config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("http://somehost:80")).withNamespace("testns")).build();
        this.assertConfig((Config)config);
    }

    @Test
    public void testWithKubeConfig() {
        System.setProperty("kubeconfig", this.getClass().getResource("/test-kubeconfig").getFile());
        Config config = new Config();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"https://172.28.128.4:8443/", (Object)config.getMasterUrl());
        Assert.assertEquals((Object)"testns", (Object)config.getNamespace());
        Assert.assertEquals((Object)"token", (Object)config.getOauthToken());
    }

    @Test
    public void testWithKubeConfigAndSystemProperties() {
        System.setProperty("kubeconfig", this.getClass().getResource("/test-kubeconfig").getFile());
        System.setProperty("kubernetes.master", "http://somehost:80");
        Config config = new Config();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"http://somehost:80/", (Object)config.getMasterUrl());
        Assert.assertEquals((Object)"testns", (Object)config.getNamespace());
        Assert.assertEquals((Object)"token", (Object)config.getOauthToken());
    }

    @Test
    public void testWithKubeConfigAndSytemPropertiesAndBuilder() {
        System.setProperty("kubeconfig", this.getClass().getResource("/test-kubeconfig").getFile());
        System.setProperty("kubernetes.master", "http://somehost:80");
        EditableConfig config = ((ConfigBuilder)new ConfigBuilder().withNamespace("testns2")).build();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"http://somehost:80/", (Object)config.getMasterUrl());
        Assert.assertEquals((Object)"testns2", (Object)config.getNamespace());
        Assert.assertEquals((Object)"token", (Object)config.getOauthToken());
    }

    private void assertConfig(Config config) {
        Assert.assertNotNull((Object)config);
        Assert.assertTrue((boolean)config.isTrustCerts());
        Assert.assertEquals((Object)"http://somehost:80/", (Object)config.getMasterUrl());
        Assert.assertEquals((Object)"testns", (Object)config.getNamespace());
        Assert.assertEquals((Object)"token", (Object)config.getOauthToken());
        Assert.assertEquals((Object)"user", (Object)config.getUsername());
        Assert.assertEquals((Object)"pass", (Object)config.getPassword());
        Assert.assertEquals((Object)"/path/to/cert", (Object)config.getCaCertFile());
        Assert.assertEquals((Object)"cacertdata", (Object)config.getCaCertData());
        Assert.assertEquals((Object)"/path/to/clientcert", (Object)config.getClientCertFile());
        Assert.assertEquals((Object)"clientcertdata", (Object)config.getClientCertData());
        Assert.assertEquals((Object)"/path/to/clientkey", (Object)config.getClientKeyFile());
        Assert.assertEquals((Object)"clientkeydata", (Object)config.getClientKeyData());
        Assert.assertEquals((Object)"algo", (Object)config.getClientKeyAlgo());
        Assert.assertEquals((Object)"passphrase", (Object)config.getClientKeyPassphrase());
        Assert.assertEquals((Object)"httpProxy", (Object)config.getProxy());
        Assert.assertEquals((long)5000L, (long)config.getWatchReconnectInterval());
        Assert.assertEquals((long)5L, (long)config.getWatchReconnectLimit());
        Assert.assertEquals((long)5000L, (long)config.getRequestTimeout());
    }
}

