/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.Reaper;
import io.fabric8.kubernetes.client.dsl.internal.ReaperFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasMetadataOperation<K extends KubernetesClient, T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends ClientResource<T, D>>
extends BaseOperation<K, T, L, D, R> {
    private static final Logger logger = LoggerFactory.getLogger(HasMetadataOperation.class);

    protected HasMetadataOperation(K client, String resourceT, String namespace, String name, Boolean cascading, T item) {
        super(client, resourceT, namespace, name, cascading, item);
    }

    protected HasMetadataOperation(K client, String resourceT, String namespace, String name, Boolean cascading, T item, Class<K> clientType, Class<T> type, Class<L> listType, Class<D> doneableType) {
        super(client, resourceT, namespace, name, cascading, item, clientType, type, listType, doneableType);
    }

    @Override
    public D edit() throws KubernetesClientException {
        final HasMetadataOperation oper = this;
        Visitor visitor = new Visitor<T>(){

            public void visit(T resource) {
                try {
                    Reaper reaper;
                    if (HasMetadataOperation.this.isCascading().booleanValue() && !HasMetadataOperation.this.isReaping() && (reaper = ReaperFactory.getReaper(oper)) != null) {
                        HasMetadataOperation.this.setReaping(true);
                        reaper.reap();
                    }
                    HasMetadataOperation.this.replace(resource);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        };
        try {
            return (D)((Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Visitor.class).newInstance(this.get(), visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public T replace(T item) {
        Exception caught = null;
        int maxTries = 5;
        for (int i = 0; i < maxTries; ++i) {
            try {
                Reaper reaper;
                if (this.isCascading().booleanValue() && (reaper = ReaperFactory.getReaper(this)) != null && !this.isReaping()) {
                    this.setReaping(true);
                    reaper.reap();
                }
                item.getMetadata().setResourceVersion(null);
                return (T)((HasMetadata)this.handleReplace(this.getResourceUrl(), item));
            }
            catch (Exception e) {
                caught = e;
                if (i >= maxTries - 1) continue;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw KubernetesClientException.launderThrowable(caught);
    }
}

