/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.server.mock;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.server.mock.KubernetesMockServer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class MasterProtocolTest {
    @Test
    public void testWithSSL() throws IOException {
        KubernetesMockServer sslServer = new KubernetesMockServer();
        sslServer.init();
        String host = sslServer.getServer().getHostName();
        Integer port = sslServer.getServer().getPort();
        Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(host + ":" + port)).withTrustCerts(true)).build();
        Assert.assertTrue((boolean)config.getMasterUrl().startsWith(Config.HTTPS_PROTOCOL_PREFIX));
        sslServer.destroy();
    }

    @Test
    public void testWithoutSSL() throws IOException {
        KubernetesMockServer plainServer = new KubernetesMockServer(false);
        plainServer.init();
        String host = plainServer.getServer().getHostName();
        Integer port = plainServer.getServer().getPort();
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(host + ":" + port)).build();
        Assert.assertTrue((boolean)config.getMasterUrl().startsWith(Config.HTTP_PROTOCOL_PREFIX));
        plainServer.destroy();
    }
}

