/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.com.ning.http.client.cookie;

import io.fabric8.kubernetes.client.internal.com.ning.http.client.cookie.Cookie;
import io.fabric8.kubernetes.client.internal.com.ning.http.util.StringUtils;
import java.util.Collection;

public final class CookieEncoder {
    private CookieEncoder() {
    }

    public static String encode(Collection<Cookie> cookies) {
        StringBuilder sb = StringUtils.stringBuilder();
        for (Cookie cookie : cookies) {
            CookieEncoder.add(sb, cookie.getName(), cookie.getValue(), cookie.isWrap());
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    private static void add(StringBuilder sb, String name, String val, boolean wrap) {
        if (val == null) {
            val = "";
        }
        sb.append(name);
        sb.append('=');
        if (wrap) {
            sb.append('\"').append(val).append('\"');
        } else {
            sb.append(val);
        }
        sb.append(';');
        sb.append(' ');
    }
}

