/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.util.List;

public class ConfigFluent<T extends ConfigFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    boolean trustCerts;
    String masterUrl;
    String apiVersion;
    List<String> enabledProtocols = new ArrayList<String>();
    String caCertFile;
    String caCertData;
    String clientCertFile;
    String clientCertData;
    String clientKeyFile;
    String clientKeyData;
    String clientKeyAlgo;
    String clientKeyPassphrase;
    String username;
    String password;
    String oauthToken;

    public boolean isTrustCerts() {
        return this.trustCerts;
    }

    public T withTrustCerts(boolean trustCerts) {
        this.trustCerts = trustCerts;
        return (T)((Object)this);
    }

    public String getMasterUrl() {
        return this.masterUrl;
    }

    public T withMasterUrl(String masterUrl) {
        this.masterUrl = masterUrl;
        return (T)((Object)this);
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (T)((Object)this);
    }

    public T withEnabledProtocols(String ... enabledProtocols) {
        this.enabledProtocols.clear();
        if (enabledProtocols != null) {
            for (String item : enabledProtocols) {
                this.addToEnabledProtocols(item);
            }
        }
        return (T)((Object)this);
    }

    public String[] getEnabledProtocols() {
        ArrayList<String> result = new ArrayList<String>();
        for (String item : this.enabledProtocols) {
            result.add(item);
        }
        return result.toArray(new String[result.size()]);
    }

    public T addToEnabledProtocols(String ... items) {
        for (String item : items) {
            this.enabledProtocols.add(item);
        }
        return (T)((Object)this);
    }

    public T removeFromEnabledProtocols(String ... items) {
        for (String item : items) {
            this.enabledProtocols.remove(item);
        }
        return (T)((Object)this);
    }

    public String getCaCertFile() {
        return this.caCertFile;
    }

    public T withCaCertFile(String caCertFile) {
        this.caCertFile = caCertFile;
        return (T)((Object)this);
    }

    public String getCaCertData() {
        return this.caCertData;
    }

    public T withCaCertData(String caCertData) {
        this.caCertData = caCertData;
        return (T)((Object)this);
    }

    public String getClientCertFile() {
        return this.clientCertFile;
    }

    public T withClientCertFile(String clientCertFile) {
        this.clientCertFile = clientCertFile;
        return (T)((Object)this);
    }

    public String getClientCertData() {
        return this.clientCertData;
    }

    public T withClientCertData(String clientCertData) {
        this.clientCertData = clientCertData;
        return (T)((Object)this);
    }

    public String getClientKeyFile() {
        return this.clientKeyFile;
    }

    public T withClientKeyFile(String clientKeyFile) {
        this.clientKeyFile = clientKeyFile;
        return (T)((Object)this);
    }

    public String getClientKeyData() {
        return this.clientKeyData;
    }

    public T withClientKeyData(String clientKeyData) {
        this.clientKeyData = clientKeyData;
        return (T)((Object)this);
    }

    public String getClientKeyAlgo() {
        return this.clientKeyAlgo;
    }

    public T withClientKeyAlgo(String clientKeyAlgo) {
        this.clientKeyAlgo = clientKeyAlgo;
        return (T)((Object)this);
    }

    public String getClientKeyPassphrase() {
        return this.clientKeyPassphrase;
    }

    public T withClientKeyPassphrase(String clientKeyPassphrase) {
        this.clientKeyPassphrase = clientKeyPassphrase;
        return (T)((Object)this);
    }

    public String getUsername() {
        return this.username;
    }

    public T withUsername(String username) {
        this.username = username;
        return (T)((Object)this);
    }

    public String getPassword() {
        return this.password;
    }

    public T withPassword(String password) {
        this.password = password;
        return (T)((Object)this);
    }

    public String getOauthToken() {
        return this.oauthToken;
    }

    public T withOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
        return (T)((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ConfigFluent that = (ConfigFluent)((Object)o);
        if (this.trustCerts != that.trustCerts) {
            return false;
        }
        if (this.masterUrl != null ? !this.masterUrl.equals(that.masterUrl) : that.masterUrl != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.enabledProtocols != null ? !this.enabledProtocols.equals(that.enabledProtocols) : that.enabledProtocols != null) {
            return false;
        }
        if (this.caCertFile != null ? !this.caCertFile.equals(that.caCertFile) : that.caCertFile != null) {
            return false;
        }
        if (this.caCertData != null ? !this.caCertData.equals(that.caCertData) : that.caCertData != null) {
            return false;
        }
        if (this.clientCertFile != null ? !this.clientCertFile.equals(that.clientCertFile) : that.clientCertFile != null) {
            return false;
        }
        if (this.clientCertData != null ? !this.clientCertData.equals(that.clientCertData) : that.clientCertData != null) {
            return false;
        }
        if (this.clientKeyFile != null ? !this.clientKeyFile.equals(that.clientKeyFile) : that.clientKeyFile != null) {
            return false;
        }
        if (this.clientKeyData != null ? !this.clientKeyData.equals(that.clientKeyData) : that.clientKeyData != null) {
            return false;
        }
        if (this.clientKeyAlgo != null ? !this.clientKeyAlgo.equals(that.clientKeyAlgo) : that.clientKeyAlgo != null) {
            return false;
        }
        if (this.clientKeyPassphrase != null ? !this.clientKeyPassphrase.equals(that.clientKeyPassphrase) : that.clientKeyPassphrase != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        return !(this.oauthToken != null ? !this.oauthToken.equals(that.oauthToken) : that.oauthToken != null);
    }
}

