/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Realm;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.RequestFilter;
import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.DoneableEndpoints;
import io.fabric8.kubernetes.api.model.DoneableEvent;
import io.fabric8.kubernetes.api.model.DoneableNamespace;
import io.fabric8.kubernetes.api.model.DoneableNode;
import io.fabric8.kubernetes.api.model.DoneablePersistentVolume;
import io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.DoneableResourceQuota;
import io.fabric8.kubernetes.api.model.DoneableSecret;
import io.fabric8.kubernetes.api.model.DoneableService;
import io.fabric8.kubernetes.api.model.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.OpenShiftClient;
import io.fabric8.kubernetes.client.dsl.BuildConfigResource;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Operation;
import io.fabric8.kubernetes.client.dsl.ProcessableResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ScaleableResource;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.BuildConfigOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.BuildOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.DeploymentConfigOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.EndpointsOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.EventOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.ImageStreamOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.NamespaceOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.NodeOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.OAuthAccessTokenOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.OAuthAuthorizeTokenOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.OAuthClientOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.PersistentVolumeClaimOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.PersistentVolumeOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.ReplicationControllerOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.ResourceQuotaOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.RouteOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.SecretOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.ServiceAccountOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.ServiceOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.TemplateOperationsImpl;
import io.fabric8.kubernetes.client.internal.CertUtils;
import io.fabric8.kubernetes.client.internal.KubeConfigUtils;
import io.fabric8.kubernetes.client.internal.Utils;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.DoneableBuild;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.DoneableOAuthAccessToken;
import io.fabric8.openshift.api.model.DoneableOAuthAuthorizeToken;
import io.fabric8.openshift.api.model.DoneableOAuthClient;
import io.fabric8.openshift.api.model.DoneableTemplate;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientList;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateList;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKubernetesClient
implements KubernetesClient,
OpenShiftClient {
    public static final String KUBERNETES_MASTER_SYSTEM_PROPERTY = "kubernetes.master";
    public static final String KUBERNETES_API_VERSION_SYSTEM_PROPERTY = "kubernetes.api.version";
    public static final String KUBERNETES_OAPI_VERSION_SYSTEM_PROPERTY = "kubernetes.oapi.version";
    public static final String KUBERNETES_TLS_PROTOCOLS_SYSTEM_PROPERTY = "kubernetes.tls.protocols";
    public static final String KUBERNETES_TRUST_CERT_SYSTEM_PROPERTY = "kubernetes.trust.certificates";
    public static final String KUBERNETES_CA_CERTIFICATE_FILE_SYSTEM_PROPERTY = "kubernetes.certs.ca.file";
    public static final String KUBERNETES_CA_CERTIFICATE_DATA_SYSTEM_PROPERTY = "kubernetes.certs.ca.data";
    public static final String KUBERNETES_CLIENT_CERTIFICATE_FILE_SYSTEM_PROPERTY = "kubernetes.certs.client.file";
    public static final String KUBERNETES_CLIENT_CERTIFICATE_DATA_SYSTEM_PROPERTY = "kubernetes.certs.client.data";
    public static final String KUBERNETES_CLIENT_KEY_FILE_SYSTEM_PROPERTY = "kubernetes.certs.client.key.file";
    public static final String KUBERNETES_CLIENT_KEY_DATA_SYSTEM_PROPERTY = "kubernetes.certs.client.key.data";
    public static final String KUBERNETES_CLIENT_KEY_ALGO_SYSTEM_PROPERTY = "kubernetes.certs.client.key.algo";
    public static final String KUBERNETES_CLIENT_KEY_PASSPHRASE_SYSTEM_PROPERTY = "kubernetes.certs.client.key.passphrase";
    public static final String KUBERNETES_AUTH_BASIC_USERNAME_SYSTEM_PROPERTY = "kubernetes.auth.basic.username";
    public static final String KUBERNETES_AUTH_BASIC_PASSWORD_SYSTEM_PROPERTY = "kubernetes.auth.basic.password";
    public static final String KUBERNETES_AUTH_TRYKUBECONFIG_SYSTEM_PROPERTY = "kubernetes.auth.tryKubeConfig";
    public static final String KUBERNETES_AUTH_TRYSERVICEACCOUNT_SYSTEM_PROPERTY = "kubernetes.auth.tryServiceAccount";
    public static final String KUBERNETES_OAUTH_TOKEN_SYSTEM_PROPERTY = "kubernetes.auth.token";
    public static final String KUBERNETES_KUBECONFIG_FILE = "kubeconfig";
    public static final String KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    public static final String KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    private AsyncHttpClient httpClient;
    private URL masterUrl;
    private URL openShiftUrl;

    public DefaultKubernetesClient() throws KubernetesClientException {
        this(new ConfigBuilder().build());
    }

    public DefaultKubernetesClient(final Config config) throws KubernetesClientException {
        if (config.getMasterUrl() == null) {
            throw new KubernetesClientException("Unknown Kubernetes master URL - please set with the builder, or set with either system property \"kubernetes.master\" or environment variable \"" + Utils.convertSystemPropertyNameToEnvVar(KUBERNETES_MASTER_SYSTEM_PROPERTY) + "\"");
        }
        try {
            this.masterUrl = new URL(config.getMasterUrl());
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
            AsyncHttpClientConfig.Builder clientConfigBuilder = new AsyncHttpClientConfig.Builder();
            clientConfigBuilder.setEnabledProtocols(config.getEnabledProtocols());
            clientConfigBuilder.setFollowRedirect(true);
            clientConfigBuilder.setAcceptAnyCertificate(config.isTrustCerts());
            TrustManager[] trustManagers = null;
            if (config.getCaCertFile() != null || config.getCaCertData() != null) {
                KeyStore trustStore = CertUtils.createTrustStore(config.getCaCertData(), config.getCaCertFile());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(trustStore);
                trustManagers = tmf.getTrustManagers();
            }
            KeyManager[] keyManagers = null;
            if (!(config.getClientCertFile() == null && config.getClientCertData() == null || config.getClientKeyFile() == null && config.getClientKeyData() == null)) {
                KeyStore keyStore = CertUtils.createKeyStore(config.getClientCertData(), config.getClientCertFile(), config.getClientKeyData(), config.getClientKeyFile(), config.getClientKeyAlgo(), config.getClientKeyPassphrase());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(keyStore, config.getClientKeyPassphrase());
                keyManagers = kmf.getKeyManagers();
            }
            if (keyManagers != null || trustManagers != null) {
                if (trustManagers == null && config.isTrustCerts()) {
                    trustManagers = InsecureTrustManagerFactory.INSTANCE.getTrustManagers();
                    clientConfigBuilder.setHostnameVerifier(null);
                }
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(keyManagers, trustManagers, new SecureRandom());
                clientConfigBuilder.setSSLContext(sslContext);
            }
            if (config.getUsername() != null && config.getPassword() != null) {
                Realm realm = new Realm.RealmBuilder().setPrincipal(config.getUsername()).setPassword(config.getPassword()).setUsePreemptiveAuth(true).setScheme(Realm.AuthScheme.BASIC).build();
                clientConfigBuilder.setRealm(realm);
            } else if (config.getOauthToken() != null) {
                clientConfigBuilder.addRequestFilter(new RequestFilter(){

                    public <T> FilterContext<T> filter(FilterContext<T> ctx) throws FilterException {
                        ctx.getRequest().getHeaders().add("Authorization", "Bearer " + config.getOauthToken());
                        return ctx;
                    }
                });
            }
            this.httpClient = new AsyncHttpClient(clientConfigBuilder.build());
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
            throw new KubernetesClientException("Could not create HTTP client", e);
        }
    }

    public DefaultKubernetesClient(String masterUrl) throws KubernetesClientException {
        Config config = new ConfigBuilder().masterUrl(masterUrl).build();
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    @Override
    public Operation<Endpoints, EndpointsList, DoneableEndpoints, Resource<Endpoints, DoneableEndpoints>> endpoints() {
        return new EndpointsOperationsImpl(this.httpClient, this.masterUrl);
    }

    @Override
    public Operation<Event, EventList, DoneableEvent, Resource<Event, DoneableEvent>> events() {
        return new EventOperationsImpl(this.httpClient, this.masterUrl);
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, Resource<Namespace, DoneableNamespace>> namespaces() {
        return new NamespaceOperationsImpl(this.httpClient, this.masterUrl);
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, DoneableNode, Resource<Node, DoneableNode>> nodes() {
        return new NodeOperationsImpl(this.httpClient, this.masterUrl);
    }

    @Override
    public Operation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, Resource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return new PersistentVolumeOperationsImpl(this.httpClient, this.masterUrl);
    }

    @Override
    public Operation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, Resource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return new PersistentVolumeClaimOperationsImpl(this.httpClient, this.masterUrl);
    }

    @Override
    public Operation<Pod, PodList, DoneablePod, Resource<Pod, DoneablePod>> pods() {
        return new PodOperationsImpl(this.httpClient, this.masterUrl);
    }

    @Override
    public Operation<ReplicationController, ReplicationControllerList, DoneableReplicationController, ScaleableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return new ReplicationControllerOperationsImpl(this.httpClient, this.masterUrl);
    }

    @Override
    public Operation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, Resource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return new ResourceQuotaOperationsImpl(this.httpClient, this.masterUrl);
    }

    @Override
    public Operation<Secret, SecretList, DoneableSecret, Resource<Secret, DoneableSecret>> secrets() {
        return new SecretOperationsImpl(this.httpClient, this.masterUrl);
    }

    @Override
    public Operation<Service, ServiceList, DoneableService, Resource<Service, DoneableService>> services() {
        return new ServiceOperationsImpl(this.httpClient, this.masterUrl);
    }

    @Override
    public Operation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, Resource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return new ServiceAccountOperationsImpl(this.httpClient, this.masterUrl);
    }

    @Override
    public Operation<Template, TemplateList, DoneableTemplate, ProcessableResource<Template, DoneableTemplate>> templates() {
        return new TemplateOperationsImpl(this.httpClient, this.openShiftUrl);
    }

    @Override
    public URL getMasterUrl() {
        return this.masterUrl;
    }

    @Override
    public RootPaths rootPaths() {
        return (RootPaths)new BaseOperation(this.httpClient, this.masterUrl, "", null, null, RootPaths.class, null, null){}.get();
    }

    @Override
    public Operation<Build, BuildList, DoneableBuild, Resource<Build, DoneableBuild>> builds() {
        return new BuildOperationsImpl(this.httpClient, this.openShiftUrl);
    }

    @Override
    public Operation<BuildConfig, BuildConfigList, DoneableBuildConfig, BuildConfigResource<BuildConfig, DoneableBuildConfig>> buildConfigs() {
        return new BuildConfigOperationsImpl(this.httpClient, this.openShiftUrl, null, null);
    }

    public Operation deploymentConfigs() {
        return new DeploymentConfigOperationsImpl(this.httpClient, this.openShiftUrl);
    }

    public Operation imageStreams() {
        return new ImageStreamOperationsImpl(this.httpClient, this.openShiftUrl);
    }

    @Override
    public NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, DoneableOAuthAccessToken, Resource<OAuthAccessToken, DoneableOAuthAccessToken>> oAuthAccessTokens() {
        return new OAuthAccessTokenOperationsImpl(this.httpClient, this.openShiftUrl);
    }

    @Override
    public NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, DoneableOAuthAuthorizeToken, Resource<OAuthAuthorizeToken, DoneableOAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return new OAuthAuthorizeTokenOperationsImpl(this.httpClient, this.openShiftUrl);
    }

    @Override
    public NonNamespaceOperation<OAuthClient, OAuthClientList, DoneableOAuthClient, Resource<OAuthClient, DoneableOAuthClient>> oAuthClients() {
        return new OAuthClientOperationsImpl(this.httpClient, this.openShiftUrl);
    }

    public Operation routes() {
        return new RouteOperationsImpl(this.httpClient, this.openShiftUrl);
    }

    public static class ConfigBuilder {
        protected final Logger logger = LoggerFactory.getLogger(this.getClass());
        private Config config = new Config();

        public ConfigBuilder() {
            if (Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_AUTH_TRYSERVICEACCOUNT_SYSTEM_PROPERTY, true).booleanValue()) {
                this.tryServiceAccount(this.config);
            }
            if (Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_AUTH_TRYKUBECONFIG_SYSTEM_PROPERTY, true).booleanValue()) {
                this.tryKubeConfig(this.config);
            }
            this.configFromSysPropsOrEnvVars(this.config);
        }

        public Config build() {
            if (!this.config.getMasterUrl().endsWith("/")) {
                this.config.setMasterUrl(this.config.getMasterUrl() + "/");
            }
            if (this.config.getOpenShiftUrl() == null) {
                this.config.setOpenShiftUrl(this.config.getMasterUrl() + "oapi/" + this.config.getOapiVersion() + "/");
            }
            this.config.setMasterUrl(this.config.getMasterUrl() + "api/" + this.config.getApiVersion() + "/");
            return this.config;
        }

        private void configFromSysPropsOrEnvVars(Config config) {
            config.setTrustCerts(Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_TRUST_CERT_SYSTEM_PROPERTY, config.isTrustCerts()));
            config.setMasterUrl(Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_MASTER_SYSTEM_PROPERTY, config.getMasterUrl()));
            config.setApiVersion(Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_API_VERSION_SYSTEM_PROPERTY, config.getApiVersion()));
            config.setOapiVersion(Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_OAPI_VERSION_SYSTEM_PROPERTY, config.getOapiVersion()));
            config.setCaCertFile(Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_CA_CERTIFICATE_FILE_SYSTEM_PROPERTY, config.getCaCertFile()));
            config.setCaCertData(Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_CA_CERTIFICATE_DATA_SYSTEM_PROPERTY, config.getCaCertData()));
            config.setClientCertFile(Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_CLIENT_CERTIFICATE_FILE_SYSTEM_PROPERTY, config.getClientCertFile()));
            config.setClientCertData(Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_CLIENT_CERTIFICATE_DATA_SYSTEM_PROPERTY, config.getClientCertData()));
            config.setClientKeyFile(Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_CLIENT_KEY_FILE_SYSTEM_PROPERTY, config.getClientKeyFile()));
            config.setClientKeyData(Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_CLIENT_KEY_DATA_SYSTEM_PROPERTY, config.getClientKeyData()));
            config.setClientKeyAlgo(Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_CLIENT_KEY_ALGO_SYSTEM_PROPERTY, config.getClientKeyAlgo()));
            config.setClientKeyPassphrase(Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_CLIENT_KEY_PASSPHRASE_SYSTEM_PROPERTY, new String(config.getClientKeyPassphrase())).toCharArray());
            config.setOauthToken(Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_OAUTH_TOKEN_SYSTEM_PROPERTY, config.getOauthToken()));
            config.setUsername(Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_AUTH_BASIC_USERNAME_SYSTEM_PROPERTY, config.getUsername()));
            config.setPassword(Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_AUTH_BASIC_PASSWORD_SYSTEM_PROPERTY, config.getPassword()));
            String configuredProtocols = Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_TLS_PROTOCOLS_SYSTEM_PROPERTY);
            if (configuredProtocols != null) {
                config.setEnabledProtocols(configuredProtocols.split(","));
            }
        }

        private void tryServiceAccount(Config config) {
            boolean serviceAccountCaCertExists = Files.isRegularFile(Paths.get(DefaultKubernetesClient.KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH, new String[0]), new LinkOption[0]);
            if (serviceAccountCaCertExists) {
                config.setCaCertFile(DefaultKubernetesClient.KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH);
            }
            try {
                String serviceTokenCandidate = new String(Files.readAllBytes(Paths.get(DefaultKubernetesClient.KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH, new String[0])));
                if (serviceTokenCandidate != null) {
                    config.setOauthToken(serviceTokenCandidate);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void tryKubeConfig(Config config) {
            String kubeConfigFile = Utils.getSystemPropertyOrEnvVar(DefaultKubernetesClient.KUBERNETES_KUBECONFIG_FILE, new File(System.getProperty("user.home", "."), ".kube/config").toString());
            boolean kubeConfigFileExists = Files.isRegularFile(Paths.get(kubeConfigFile, new String[0]), new LinkOption[0]);
            if (kubeConfigFileExists) {
                try {
                    io.fabric8.kubernetes.api.model.Config kubeConfig = KubeConfigUtils.parseConfig(new File(kubeConfigFile));
                    Context currentContext = KubeConfigUtils.getCurrentContext(kubeConfig);
                    Cluster currentCluster = KubeConfigUtils.getCluster(kubeConfig, currentContext);
                    if (currentCluster != null) {
                        config.setMasterUrl(currentCluster.getServer());
                        config.setTrustCerts(currentCluster.getInsecureSkipTlsVerify() != null && currentCluster.getInsecureSkipTlsVerify() != false);
                        config.setCaCertFile(currentCluster.getCertificateAuthority());
                        config.setCaCertData(currentCluster.getCertificateAuthorityData());
                        AuthInfo currentAuthInfo = KubeConfigUtils.getUserAuthInfo(kubeConfig, currentContext);
                        if (currentAuthInfo != null) {
                            config.setClientCertFile(currentAuthInfo.getClientCertificate());
                            config.setClientCertData(currentAuthInfo.getClientCertificateData());
                            config.setClientKeyFile(currentAuthInfo.getClientKey());
                            config.setClientKeyData(currentAuthInfo.getClientKeyData());
                            config.setOauthToken(currentAuthInfo.getToken());
                            config.setUsername(currentAuthInfo.getUsername());
                            config.setPassword(currentAuthInfo.getPassword());
                        }
                    }
                }
                catch (IOException e) {
                    this.logger.error("Could not load kube config file from {}", (Object)kubeConfigFile, (Object)e);
                }
            }
        }

        public ConfigBuilder enabledProtocols(String[] enabledProtocols) {
            this.config.setEnabledProtocols(enabledProtocols);
            return this;
        }

        public ConfigBuilder trustCerts(boolean trustCerts) {
            this.config.setTrustCerts(trustCerts);
            return this;
        }

        public ConfigBuilder caCertFile(String caCertFile) {
            this.config.setCaCertFile(caCertFile);
            return this;
        }

        public ConfigBuilder caCertData(String caCertData) {
            this.config.setCaCertData(caCertData);
            return this;
        }

        public ConfigBuilder clientCertFile(String clientCertFile) {
            this.config.setClientCertFile(clientCertFile);
            return this;
        }

        public ConfigBuilder clientCertData(String clientCertData) {
            this.config.setClientCertData(clientCertData);
            return this;
        }

        public ConfigBuilder clientKeyFile(String clientKeyFile) {
            this.config.setClientKeyFile(clientKeyFile);
            return this;
        }

        public ConfigBuilder clientKeyData(String clientKeyData) {
            this.config.setClientKeyData(clientKeyData);
            return this;
        }

        public ConfigBuilder clientKeyAlgo(String clientKeyAlgo) {
            this.config.setClientKeyAlgo(clientKeyAlgo);
            return this;
        }

        public ConfigBuilder clientKeyPassphrase(char[] clientKeyPassphrase) {
            this.config.setClientKeyPassphrase(clientKeyPassphrase);
            return this;
        }

        public ConfigBuilder masterUrl(String masterUrl) {
            this.config.setMasterUrl(masterUrl);
            return this;
        }

        public ConfigBuilder apiVersion(String apiVersion) {
            this.config.setApiVersion(apiVersion);
            return this;
        }

        public ConfigBuilder basicAuth(String username, String password) {
            this.config.setUsername(username);
            this.config.setPassword(password);
            return this;
        }

        public ConfigBuilder token(String token) {
            this.config.setOauthToken(token);
            return this;
        }
    }

    public static class Config {
        private boolean trustCerts = false;
        private String masterUrl = "https://kubernetes.default.svc.cluster.local";
        private String apiVersion = "v1";
        private String oapiVersion = "v1";
        private String[] enabledProtocols = new String[]{"TLSv1.2"};
        private String caCertFile;
        private String caCertData;
        private String clientCertFile;
        private String clientCertData;
        private String clientKeyFile;
        private String clientKeyData;
        private String clientKeyAlgo = "RSA";
        private char[] clientKeyPassphrase = "changeit".toCharArray();
        private String username;
        private String password;
        private String oauthToken;
        private String openShiftUrl;

        public String getOauthToken() {
            return this.oauthToken;
        }

        public void setOauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public char[] getClientKeyPassphrase() {
            return this.clientKeyPassphrase;
        }

        public void setClientKeyPassphrase(char[] clientKeyPassphrase) {
            this.clientKeyPassphrase = clientKeyPassphrase;
        }

        public String getClientKeyAlgo() {
            return this.clientKeyAlgo;
        }

        public void setClientKeyAlgo(String clientKeyAlgo) {
            this.clientKeyAlgo = clientKeyAlgo;
        }

        public String getClientKeyData() {
            return this.clientKeyData;
        }

        public void setClientKeyData(String clientKeyData) {
            this.clientKeyData = clientKeyData;
        }

        public String getClientKeyFile() {
            return this.clientKeyFile;
        }

        public void setClientKeyFile(String clientKeyFile) {
            this.clientKeyFile = clientKeyFile;
        }

        public String getClientCertData() {
            return this.clientCertData;
        }

        public void setClientCertData(String clientCertData) {
            this.clientCertData = clientCertData;
        }

        public String getClientCertFile() {
            return this.clientCertFile;
        }

        public void setClientCertFile(String clientCertFile) {
            this.clientCertFile = clientCertFile;
        }

        public String getCaCertData() {
            return this.caCertData;
        }

        public void setCaCertData(String caCertData) {
            this.caCertData = caCertData;
        }

        public String getCaCertFile() {
            return this.caCertFile;
        }

        public void setCaCertFile(String caCertFile) {
            this.caCertFile = caCertFile;
        }

        public String[] getEnabledProtocols() {
            return this.enabledProtocols;
        }

        public void setEnabledProtocols(String[] enabledProtocols) {
            this.enabledProtocols = enabledProtocols;
        }

        public String getOapiVersion() {
            return this.oapiVersion;
        }

        public void setOapiVersion(String oapiVersion) {
            this.oapiVersion = oapiVersion;
        }

        public String getApiVersion() {
            return this.apiVersion;
        }

        public void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        public String getMasterUrl() {
            return this.masterUrl;
        }

        public void setMasterUrl(String masterUrl) {
            this.masterUrl = masterUrl;
        }

        public boolean isTrustCerts() {
            return this.trustCerts;
        }

        public void setTrustCerts(boolean trustCerts) {
            this.trustCerts = trustCerts;
        }

        public String getOpenShiftUrl() {
            return this.openShiftUrl;
        }

        public void setOpenShiftUrl(String openShiftUrl) {
            this.openShiftUrl = openShiftUrl;
        }
    }
}

