/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import com.ning.http.client.AsyncHttpClient;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.internal.DefaultResourceList;
import io.fabric8.kubernetes.client.internal.NamedResource;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;

public class NonNamespacedResourceList<T extends HasMetadata, L extends KubernetesResourceList, B extends Builder<T>, D extends Doneable<T>>
extends DefaultResourceList<T, L, B, D>
implements io.fabric8.kubernetes.client.NonNamespacedResourceList<T, L, B, D> {
    public NonNamespacedResourceList(AsyncHttpClient httpClient, URL rootUrl, String resourceT, Class<T> clazz, Class<L> listClazz, Class<B> builderClazz, Class<D> updateableClazz) {
        super(httpClient, rootUrl, resourceT, clazz, listClazz, builderClazz, updateableClazz);
    }

    @Override
    public io.fabric8.kubernetes.client.NamedResource<T, B, D> withName(String name) throws KubernetesClientException {
        try {
            return new NamedResource(name, this);
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public T create(T resource) throws KubernetesClientException {
        try {
            return this.handleCreate(resource);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public D createNew() throws KubernetesClientException {
        Visitor visitor = new Visitor<T>(){

            public void visit(T resource) {
                try {
                    NonNamespacedResourceList.this.create(resource);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        };
        try {
            return (D)((Doneable)this.getDoneableClazz().getDeclaredConstructor(Visitor.class).newInstance(visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }
}

