/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.com.ning.http.client.extra;

import io.fabric8.kubernetes.client.internal.com.ning.http.client.resumable.ResumableListener;
import io.fabric8.kubernetes.client.internal.com.ning.http.util.MiscUtils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class ResumableRandomAccessFileListener
implements ResumableListener {
    private final RandomAccessFile file;

    public ResumableRandomAccessFileListener(RandomAccessFile file) {
        this.file = file;
    }

    @Override
    public void onBytesReceived(ByteBuffer buffer) throws IOException {
        this.file.seek(this.file.length());
        this.file.write(buffer.array());
    }

    @Override
    public void onAllBytesReceived() {
        MiscUtils.closeSilently(this.file);
    }

    @Override
    public long length() {
        try {
            return this.file.length();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }
}

