/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.client.ConfigFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigFluentImpl<T extends ConfigFluent<T>>
extends BaseFluent<T>
implements ConfigFluent<T> {
    boolean trustCerts;
    String masterUrl;
    String apiVersion;
    String namespace;
    List<String> enabledProtocols = new ArrayList<String>();
    String caCertFile;
    String caCertData;
    String clientCertFile;
    String clientCertData;
    String clientKeyFile;
    String clientKeyData;
    String clientKeyAlgo;
    String clientKeyPassphrase;
    String username;
    String password;
    String oauthToken;
    int watchReconnectInterval;
    int watchReconnectLimit;
    int requestTimeout;
    long rollingTimeout;
    int loggingInterval;
    String proxy;
    Map<Integer, String> errorMessages = new HashMap<Integer, String>();

    @Override
    public boolean isTrustCerts() {
        return this.trustCerts;
    }

    @Override
    public T withTrustCerts(boolean trustCerts) {
        this.trustCerts = trustCerts;
        return (T)this;
    }

    @Override
    public String getMasterUrl() {
        return this.masterUrl;
    }

    @Override
    public T withMasterUrl(String masterUrl) {
        this.masterUrl = masterUrl;
        return (T)this;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public T withNamespace(String namespace) {
        this.namespace = namespace;
        return (T)this;
    }

    @Override
    public T withEnabledProtocols(String ... enabledProtocols) {
        this.enabledProtocols.clear();
        if (enabledProtocols != null) {
            for (String item : enabledProtocols) {
                this.addToEnabledProtocols(item);
            }
        }
        return (T)this;
    }

    @Override
    public String[] getEnabledProtocols() {
        ArrayList<String> result = new ArrayList<String>();
        for (String item : this.enabledProtocols) {
            result.add(item);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public T addToEnabledProtocols(String ... items) {
        for (String item : items) {
            this.enabledProtocols.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromEnabledProtocols(String ... items) {
        for (String item : items) {
            this.enabledProtocols.remove(item);
        }
        return (T)this;
    }

    @Override
    public String getCaCertFile() {
        return this.caCertFile;
    }

    @Override
    public T withCaCertFile(String caCertFile) {
        this.caCertFile = caCertFile;
        return (T)this;
    }

    @Override
    public String getCaCertData() {
        return this.caCertData;
    }

    @Override
    public T withCaCertData(String caCertData) {
        this.caCertData = caCertData;
        return (T)this;
    }

    @Override
    public String getClientCertFile() {
        return this.clientCertFile;
    }

    @Override
    public T withClientCertFile(String clientCertFile) {
        this.clientCertFile = clientCertFile;
        return (T)this;
    }

    @Override
    public String getClientCertData() {
        return this.clientCertData;
    }

    @Override
    public T withClientCertData(String clientCertData) {
        this.clientCertData = clientCertData;
        return (T)this;
    }

    @Override
    public String getClientKeyFile() {
        return this.clientKeyFile;
    }

    @Override
    public T withClientKeyFile(String clientKeyFile) {
        this.clientKeyFile = clientKeyFile;
        return (T)this;
    }

    @Override
    public String getClientKeyData() {
        return this.clientKeyData;
    }

    @Override
    public T withClientKeyData(String clientKeyData) {
        this.clientKeyData = clientKeyData;
        return (T)this;
    }

    @Override
    public String getClientKeyAlgo() {
        return this.clientKeyAlgo;
    }

    @Override
    public T withClientKeyAlgo(String clientKeyAlgo) {
        this.clientKeyAlgo = clientKeyAlgo;
        return (T)this;
    }

    @Override
    public String getClientKeyPassphrase() {
        return this.clientKeyPassphrase;
    }

    @Override
    public T withClientKeyPassphrase(String clientKeyPassphrase) {
        this.clientKeyPassphrase = clientKeyPassphrase;
        return (T)this;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public T withUsername(String username) {
        this.username = username;
        return (T)this;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public T withPassword(String password) {
        this.password = password;
        return (T)this;
    }

    @Override
    public String getOauthToken() {
        return this.oauthToken;
    }

    @Override
    public T withOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
        return (T)this;
    }

    @Override
    public int getWatchReconnectInterval() {
        return this.watchReconnectInterval;
    }

    @Override
    public T withWatchReconnectInterval(int watchReconnectInterval) {
        this.watchReconnectInterval = watchReconnectInterval;
        return (T)this;
    }

    @Override
    public int getWatchReconnectLimit() {
        return this.watchReconnectLimit;
    }

    @Override
    public T withWatchReconnectLimit(int watchReconnectLimit) {
        this.watchReconnectLimit = watchReconnectLimit;
        return (T)this;
    }

    @Override
    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public T withRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return (T)this;
    }

    @Override
    public long getRollingTimeout() {
        return this.rollingTimeout;
    }

    @Override
    public T withRollingTimeout(long rollingTimeout) {
        this.rollingTimeout = rollingTimeout;
        return (T)this;
    }

    @Override
    public int getLoggingInterval() {
        return this.loggingInterval;
    }

    @Override
    public T withLoggingInterval(int loggingInterval) {
        this.loggingInterval = loggingInterval;
        return (T)this;
    }

    @Override
    public String getProxy() {
        return this.proxy;
    }

    @Override
    public T withProxy(String proxy) {
        this.proxy = proxy;
        return (T)this;
    }

    @Override
    public T addToErrorMessages(Integer key, String value) {
        if (key != null && value != null) {
            this.errorMessages.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T removeFromErrorMessages(Integer key) {
        if (key != null) {
            this.errorMessages.remove(key);
        }
        return (T)this;
    }

    @Override
    public Map<Integer, String> getErrorMessages() {
        return this.errorMessages;
    }

    @Override
    public T withErrorMessages(Map<Integer, String> errorMessages) {
        this.errorMessages.clear();
        if (errorMessages != null) {
            this.errorMessages.putAll(errorMessages);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigFluentImpl that = (ConfigFluentImpl)o;
        if (this.trustCerts != that.trustCerts) {
            return false;
        }
        if (this.masterUrl != null ? !this.masterUrl.equals(that.masterUrl) : that.masterUrl != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.enabledProtocols != null ? !this.enabledProtocols.equals(that.enabledProtocols) : that.enabledProtocols != null) {
            return false;
        }
        if (this.caCertFile != null ? !this.caCertFile.equals(that.caCertFile) : that.caCertFile != null) {
            return false;
        }
        if (this.caCertData != null ? !this.caCertData.equals(that.caCertData) : that.caCertData != null) {
            return false;
        }
        if (this.clientCertFile != null ? !this.clientCertFile.equals(that.clientCertFile) : that.clientCertFile != null) {
            return false;
        }
        if (this.clientCertData != null ? !this.clientCertData.equals(that.clientCertData) : that.clientCertData != null) {
            return false;
        }
        if (this.clientKeyFile != null ? !this.clientKeyFile.equals(that.clientKeyFile) : that.clientKeyFile != null) {
            return false;
        }
        if (this.clientKeyData != null ? !this.clientKeyData.equals(that.clientKeyData) : that.clientKeyData != null) {
            return false;
        }
        if (this.clientKeyAlgo != null ? !this.clientKeyAlgo.equals(that.clientKeyAlgo) : that.clientKeyAlgo != null) {
            return false;
        }
        if (this.clientKeyPassphrase != null ? !this.clientKeyPassphrase.equals(that.clientKeyPassphrase) : that.clientKeyPassphrase != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.oauthToken != null ? !this.oauthToken.equals(that.oauthToken) : that.oauthToken != null) {
            return false;
        }
        if (this.watchReconnectInterval != that.watchReconnectInterval) {
            return false;
        }
        if (this.watchReconnectLimit != that.watchReconnectLimit) {
            return false;
        }
        if (this.requestTimeout != that.requestTimeout) {
            return false;
        }
        if (this.rollingTimeout != that.rollingTimeout) {
            return false;
        }
        if (this.loggingInterval != that.loggingInterval) {
            return false;
        }
        if (this.proxy != null ? !this.proxy.equals(that.proxy) : that.proxy != null) {
            return false;
        }
        return !(this.errorMessages != null ? !this.errorMessages.equals(that.errorMessages) : that.errorMessages != null);
    }
}

