/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.client.Adapters;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.internal.CertUtils;
import io.fabric8.kubernetes.client.internal.Utils;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.AsyncHttpClient;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.AsyncHttpClientConfig;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.ProxyServer;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.Realm;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.filter.FilterContext;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.filter.FilterException;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.filter.RequestFilter;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class BaseClient
implements Client {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private static final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private AsyncHttpClient httpClient;
    private URL masterUrl;
    private String apiVersion;
    private String namespace;
    private Config configuration;

    public BaseClient() throws KubernetesClientException {
        this(new ConfigBuilder().build());
    }

    public BaseClient(Config config) throws KubernetesClientException {
        this(BaseClient.createHttpClient(config), config);
    }

    public BaseClient(AsyncHttpClient httpClient, Config config) throws KubernetesClientException {
        try {
            this.httpClient = httpClient;
            this.namespace = config.getNamespace();
            this.configuration = config;
            this.apiVersion = config.getApiVersion();
            if (config.getMasterUrl() == null) {
                throw new KubernetesClientException("Unknown Kubernetes master URL - please set with the builder, or set with either system property \"kubernetes.master\" or environment variable \"" + Utils.convertSystemPropertyNameToEnvVar("kubernetes.master") + "\"");
            }
            this.masterUrl = new URL(config.getMasterUrl());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    static AsyncHttpClient createHttpClient(final Config config) {
        try {
            AsyncHttpClientConfig.Builder clientConfigBuilder = new AsyncHttpClientConfig.Builder();
            clientConfigBuilder.setEnabledProtocols(config.getEnabledProtocols());
            clientConfigBuilder.setFollowRedirect(true);
            clientConfigBuilder.setAcceptAnyCertificate(config.isTrustCerts());
            TrustManager[] trustManagers = null;
            if (Utils.isNotNullOrEmpty(config.getCaCertFile()) || Utils.isNotNullOrEmpty(config.getCaCertData())) {
                KeyStore trustStore = CertUtils.createTrustStore(config.getCaCertData(), config.getCaCertFile());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(trustStore);
                trustManagers = tmf.getTrustManagers();
            }
            KeyManager[] keyManagers = null;
            if ((Utils.isNotNullOrEmpty(config.getClientCertFile()) || Utils.isNotNullOrEmpty(config.getClientCertData())) && (Utils.isNotNullOrEmpty(config.getClientKeyFile()) || Utils.isNotNullOrEmpty(config.getClientKeyData()))) {
                KeyStore keyStore = CertUtils.createKeyStore(config.getClientCertData(), config.getClientCertFile(), config.getClientKeyData(), config.getClientKeyFile(), config.getClientKeyAlgo(), config.getClientKeyPassphrase().toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(keyStore, config.getClientKeyPassphrase().toCharArray());
                keyManagers = kmf.getKeyManagers();
            }
            if (keyManagers != null || trustManagers != null) {
                if (trustManagers == null && config.isTrustCerts()) {
                    trustManagers = InsecureTrustManagerFactory.INSTANCE.getTrustManagers();
                    clientConfigBuilder.setHostnameVerifier(null);
                }
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(keyManagers, trustManagers, new SecureRandom());
                clientConfigBuilder.setSSLContext(sslContext);
            }
            if (Utils.isNotNullOrEmpty(config.getUsername()) && Utils.isNotNullOrEmpty(config.getPassword())) {
                Realm realm = new Realm.RealmBuilder().setPrincipal(config.getUsername()).setPassword(config.getPassword()).setUsePreemptiveAuth(true).setScheme(Realm.AuthScheme.BASIC).build();
                clientConfigBuilder.setRealm(realm);
            } else if (config.getOauthToken() != null) {
                clientConfigBuilder.addRequestFilter(new RequestFilter(){

                    @Override
                    public <T> FilterContext<T> filter(FilterContext<T> ctx) throws FilterException {
                        ctx.getRequest().getHeaders().add("Authorization", "Bearer " + config.getOauthToken());
                        return ctx;
                    }
                });
            }
            if (config.getRequestTimeout() > 0) {
                clientConfigBuilder.setRequestTimeout(config.getRequestTimeout());
            }
            if (config.getProxy() != null) {
                try {
                    URL u = new URL(config.getProxy());
                    clientConfigBuilder.setProxyServer(new ProxyServer(ProxyServer.Protocol.valueOf(u.getProtocol()), u.getHost(), u.getPort()));
                }
                catch (MalformedURLException e) {
                    throw new KubernetesClientException("Invalid proxy server configuration", e);
                }
            }
            NettyAsyncHttpProviderConfig nettyConfig = new NettyAsyncHttpProviderConfig();
            nettyConfig.setWebSocketMaxFrameSize(65536);
            clientConfigBuilder.setAsyncHttpClientProviderConfig(nettyConfig);
            return new AsyncHttpClient(clientConfigBuilder.build());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public BaseClient(String masterUrl) throws KubernetesClientException {
        this(((ConfigBuilder)new ConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T unmarshal(InputStream is, Class<T> type) throws KubernetesClientException {
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            int intch;
            bis.mark(-1);
            while ((intch = bis.read()) > -1 && Character.isWhitespace(intch)) {
            }
            bis.reset();
            ObjectMapper mapper = jsonMapper;
            if (intch != 123) {
                mapper = yamlMapper;
            }
            Object object = mapper.readValue((InputStream)bis, type);
            return (T)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public AsyncHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public URL getMasterUrl() {
        return this.masterUrl;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public Config getConfiguration() {
        return this.configuration;
    }

    @Override
    public <C extends Client> Boolean isAdaptable(Class<C> type) {
        ExtensionAdapter<C> adapter = Adapters.get(type);
        if (adapter != null) {
            return adapter.isAdaptable(this);
        }
        return false;
    }

    @Override
    public <C extends Client> C adapt(Class<C> type) {
        ExtensionAdapter<C> adapter = Adapters.get(type);
        if (adapter != null) {
            return adapter.adapt(this);
        }
        throw new IllegalStateException("No adapter available for type:" + type);
    }

    @Override
    public RootPaths rootPaths() {
        return new BaseOperation(this, "", null, null, false, null, RootPaths.class, null, null){}.getRootPaths();
    }
}

