/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.com.ning.http.client.multipart;

import io.fabric8.kubernetes.client.internal.com.ning.http.client.multipart.OutputStreamPartVisitor;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.multipart.PartBase;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.multipart.PartVisitor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class AbstractFilePart
extends PartBase {
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final String DEFAULT_TRANSFER_ENCODING = "binary";
    private static final byte[] FILE_NAME_BYTES = "; filename=".getBytes(StandardCharsets.US_ASCII);
    private long stalledTime = -1L;
    private String fileName;

    public AbstractFilePart(String name, String contentType, Charset charset, String contentId, String transferEncoding) {
        super(name, contentType == null ? DEFAULT_CONTENT_TYPE : contentType, charset, contentId, transferEncoding == null ? DEFAULT_TRANSFER_ENCODING : transferEncoding);
    }

    @Override
    protected void visitDispositionHeader(PartVisitor visitor) throws IOException {
        super.visitDispositionHeader(visitor);
        if (this.fileName != null) {
            visitor.withBytes(FILE_NAME_BYTES);
            visitor.withByte((byte)34);
            visitor.withBytes(this.fileName.getBytes(this.getCharset() != null ? this.getCharset() : StandardCharsets.US_ASCII));
            visitor.withByte((byte)34);
        }
    }

    protected byte[] generateFileStart(byte[] boundary) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamPartVisitor visitor = new OutputStreamPartVisitor(out);
        this.visitStart(visitor, boundary);
        this.visitDispositionHeader(visitor);
        this.visitContentTypeHeader(visitor);
        this.visitTransferEncodingHeader(visitor);
        this.visitContentIdHeader(visitor);
        this.visitCustomHeaders(visitor);
        this.visitEndOfHeaders(visitor);
        return out.toByteArray();
    }

    protected byte[] generateFileEnd() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamPartVisitor visitor = new OutputStreamPartVisitor(out);
        this.visitEnd(visitor);
        return out.toByteArray();
    }

    public void setStalledTime(long ms) {
        this.stalledTime = ms;
    }

    public long getStalledTime() {
        return this.stalledTime;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String toString() {
        return super.toString() + " filename=" + this.fileName;
    }
}

