/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.ResourceCreator;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public final class Creators {
    private static final Map<Class, ResourceCreator> RESOURCE_CREATOR_MAP = new HashMap<Class, ResourceCreator>();

    private Creators() {
    }

    public static <T extends HasMetadata> void register(ResourceCreator<T> adapter) {
        RESOURCE_CREATOR_MAP.put(adapter.getKind(), adapter);
    }

    public static <T extends HasMetadata> void unregister(ResourceCreator<T> adapter) {
        RESOURCE_CREATOR_MAP.remove(adapter.getKind());
    }

    public static <T extends HasMetadata> ResourceCreator<T> get(Class<T> type) {
        return RESOURCE_CREATOR_MAP.get(type);
    }

    static {
        for (ResourceCreator creator : ServiceLoader.load(ResourceCreator.class)) {
            Creators.register(creator);
        }
    }
}

