/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.client.internal.CertUtils;
import io.fabric8.kubernetes.client.utils.IOHelpers;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.Collections;
import java.util.Objects;
import java.util.Properties;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class CertUtilsTest {
    private static final String FABRIC8_STORE_PATH = Utils.filePath((URL)CertUtilsTest.class.getResource("/ssl-test/fabric8-store"));
    private static final String FABRIC8_STORE_PASSPHRASE = "fabric8";
    private Properties systemProperties;

    CertUtilsTest() {
    }

    @BeforeEach
    public void storeSystemProperties() {
        this.systemProperties = new Properties();
        this.storeSystemProperty("javax.net.ssl.trustStore");
        this.storeSystemProperty("javax.net.ssl.trustStorePassword");
        this.storeSystemProperty("javax.net.ssl.trustStoreType");
        this.storeSystemProperty("javax.net.ssl.keyStore");
        this.storeSystemProperty("javax.net.ssl.keyStorePassword");
    }

    private void storeSystemProperty(String systemProperty) {
        String value = System.getProperty(systemProperty);
        if (Utils.isNotNullOrEmpty((String)value)) {
            this.systemProperties.put(systemProperty, value);
        }
    }

    @AfterEach
    public void resetSystemPropertiesBack() {
        System.setProperties(this.systemProperties);
    }

    @Test
    void handleReadOnlyJavaTrustStore() throws Exception {
        KeyStore system = CertUtils.loadTrustStore(null, (char[])"changeit".toCharArray());
        KeyStore trustStore = (KeyStore)Mockito.spy((Object)system);
        ((KeyStore)Mockito.doThrow(KeyStoreException.class).when((Object)trustStore)).setCertificateEntry(Mockito.anyString(), (Certificate)Mockito.any());
        KeyStore result = CertUtils.mergePemCertsIntoTrustStore((ByteArrayInputStream)CertUtils.getInputStreamFromDataOrFile(null, (String)"src/test/resources/ssl-test/multiple-certs.pem"), (KeyStore)trustStore, (boolean)true);
        Assert.assertNotSame((Object)trustStore, (Object)result);
        ((ListAssert)((ListAssert)Assertions.assertThat(Collections.list(result.aliases())).hasSizeGreaterThanOrEqualTo(2)).satisfiesOnlyOnce(alias -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)alias).contains(new CharSequence[]{"openshift-signer"});
        })).satisfiesOnlyOnce(alias -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)alias).contains(new CharSequence[]{"openshift-service-serving-signer"});
        });
    }

    @Test
    void loadingMultipleCertsFromSameFile() throws Exception {
        KeyStore ts = CertUtils.createTrustStore(null, (String)"src/test/resources/ssl-test/multiple-certs.pem", null, (String)"changeit");
        ((ListAssert)((ListAssert)Assertions.assertThat(Collections.list(ts.aliases())).hasSizeGreaterThanOrEqualTo(2)).satisfiesOnlyOnce(alias -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)alias).contains(new CharSequence[]{"openshift-signer"});
        })).satisfiesOnlyOnce(alias -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)alias).contains(new CharSequence[]{"openshift-service-serving-signer"});
        });
    }

    @Test
    void loadingMultipleCertsWithSameSubjectFromSameFile() throws Exception {
        KeyStore ts = CertUtils.createTrustStore(null, (String)"src/test/resources/ssl-test/nonunique-subject.pem", null, (String)"changeit");
        org.junit.jupiter.api.Assertions.assertTrue((ts.size() >= 2 ? 1 : 0) != 0);
    }

    @Test
    void loadTrustStoreFromFileUsingConfigProperties() throws Exception {
        KeyStore trustStore = CertUtils.createTrustStore(null, (String)"src/test/resources/ssl-test/multiple-certs.pem", (String)FABRIC8_STORE_PATH, (String)FABRIC8_STORE_PASSPHRASE);
        ((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat(Collections.list(trustStore.aliases())).hasSizeGreaterThanOrEqualTo(3)).satisfiesOnlyOnce(alias -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)alias).contains(new CharSequence[]{"openshift-signer"});
        })).satisfiesOnlyOnce(alias -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)alias).contains(new CharSequence[]{"openshift-service-serving-signer"});
        })).satisfiesOnlyOnce(alias -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)alias).contains(new CharSequence[]{"fabric8-in-store"});
        });
        this.verifyFabric8InStore(trustStore);
    }

    @Test
    void loadTrustStoreFromFileUsingSystemProperties() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", FABRIC8_STORE_PATH);
        System.setProperty("javax.net.ssl.trustStorePassword", FABRIC8_STORE_PASSPHRASE);
        KeyStore trustStore = CertUtils.createTrustStore(null, (String)"src/test/resources/ssl-test/multiple-certs.pem", null, null);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)trustStore.size());
        this.verifyFabric8InStore(trustStore);
    }

    @Test
    void loadKeyStoreFromFileUsingConfigProperties() throws Exception {
        KeyStore trustStore = CertUtils.createKeyStore(null, (String)"src/test/resources/ssl-test/multiple-certs.pem", null, (String)"src/test/resources/ssl-test/fabric8", (String)"RSA", (String)"changeit", (String)FABRIC8_STORE_PATH, (String)FABRIC8_STORE_PASSPHRASE);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)trustStore.size());
        this.verifyFabric8InStore(trustStore);
    }

    @Test
    void loadKeyStoreFromFileUsingSystemProperties() throws Exception {
        System.setProperty("javax.net.ssl.keyStore", FABRIC8_STORE_PATH);
        System.setProperty("javax.net.ssl.keyStorePassword", String.valueOf(FABRIC8_STORE_PASSPHRASE));
        String privateKeyPath = Utils.filePath((URL)this.getClass().getResource("/ssl-test/fabric8"));
        String multipleCertsPath = Utils.filePath((URL)this.getClass().getResource("/ssl-test/multiple-certs.pem"));
        KeyStore trustStore = CertUtils.createKeyStore(null, (String)multipleCertsPath, null, (String)privateKeyPath, (String)"RSA", (String)"changeit", null, null);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)trustStore.size());
        this.verifyFabric8InStore(trustStore);
    }

    @Test
    void getInputStreamFromDataOrFileShouldNotDecodedPEMAgain() throws IOException {
        File certFile = new File(Objects.requireNonNull(this.getClass().getResource("/ssl-test/valid-non-base64-encoded-cert.pem")).getFile());
        String certData = new String(Files.readAllBytes(certFile.toPath()));
        ByteArrayInputStream inputStream = CertUtils.getInputStreamFromDataOrFile((String)certData, null);
        String certDataReadFromInputStream = IOHelpers.readFully((InputStream)inputStream);
        org.junit.jupiter.api.Assertions.assertEquals((Object)certData, (Object)certDataReadFromInputStream);
    }

    @Test
    void getInputStreamFromDataOrFileShouldDecodeBase64EncodedString() throws IOException {
        String inputStr = "this is a test";
        String base64EncodedStr = Base64.getEncoder().encodeToString(inputStr.getBytes());
        ByteArrayInputStream inputStream = CertUtils.getInputStreamFromDataOrFile((String)base64EncodedStr, null);
        String certDataReadFromInputStream = IOHelpers.readFully((InputStream)inputStream);
        org.junit.jupiter.api.Assertions.assertEquals((Object)inputStr, (Object)certDataReadFromInputStream);
    }

    @Test
    void storeKeyFallbacksToDefault() throws Exception {
        KeyStore result = CertUtils.createTrustStore(null, (String)"src/test/resources/ssl-test/multiple-certs.pem", null, (String)"");
        ((ListAssert)((ListAssert)Assertions.assertThat(Collections.list(result.aliases())).hasSizeGreaterThanOrEqualTo(2)).satisfiesOnlyOnce(alias -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)alias).contains(new CharSequence[]{"openshift-signer"});
        })).satisfiesOnlyOnce(alias -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)alias).contains(new CharSequence[]{"openshift-service-serving-signer"});
        });
    }

    private void verifyFabric8InStore(KeyStore trustStore) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        Certificate certificate = trustStore.getCertificate("fabric8-in-store");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)certificate);
        KeyStore storeWithCert = CertUtils.createTrustStore(null, (String)"src/test/resources/ssl-test/fabric8.crt", null, (String)"");
        String certificateAlias = storeWithCert.getCertificateAlias(certificate);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)certificateAlias);
    }
}

