/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.leaderelection;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderCallbacks;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigBuilder;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElector;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectorBuilder;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.ConfigMapLock;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock;
import io.fabric8.kubernetes.client.utils.CommonThreadPool;
import java.time.Duration;
import java.util.concurrent.Executor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class LeaderElectorBuilderTest {
    private NamespacedKubernetesClient mockKubernetesClient;
    private LeaderElectionConfigBuilder defaultConfigBuilder;

    LeaderElectorBuilderTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockKubernetesClient = (NamespacedKubernetesClient)Mockito.mock(NamespacedKubernetesClient.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        this.defaultConfigBuilder = (LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)new LeaderElectionConfigBuilder().withName("Valid Leader Election configuration")).withLeaseDuration(Duration.ofSeconds(15L))).withLock((Lock)new ConfigMapLock("fakeNamespace", "fakeName", "fakeIdentity"))).withRenewDeadline(Duration.ofSeconds(10L))).withRetryPeriod(Duration.ofSeconds(2L))).withLeaderCallbacks(new LeaderCallbacks(() -> {}, () -> {}, newLeader -> {}));
    }

    @Test
    void withConfigAndValidConfigurationShouldReturnConfig() {
        LeaderElectionConfig validConfig = this.defaultConfigBuilder.build();
        LeaderElector leadElector = new LeaderElectorBuilder((KubernetesClient)this.mockKubernetesClient, (Executor)CommonThreadPool.get()).withConfig(validConfig).build();
        Assertions.assertNotNull((Object)leadElector);
    }

    @Test
    void withConfigAndMissingNameShouldThrowException() {
        this.assertRequiredField(((LeaderElectionConfigBuilder)this.defaultConfigBuilder.withName(null)).build());
    }

    @Test
    void withConfigAndMissingLeaseDurationShouldThrowException() {
        this.assertRequiredField(((LeaderElectionConfigBuilder)this.defaultConfigBuilder.withLeaseDuration(null)).build());
    }

    @Test
    void withConfigAndMissingRenewDeadlineShouldThrowException() {
        this.assertRequiredField(((LeaderElectionConfigBuilder)this.defaultConfigBuilder.withRenewDeadline(null)).build());
    }

    @Test
    void withConfigAndMissingRetryPeriodShouldThrowException() {
        this.assertRequiredField(((LeaderElectionConfigBuilder)this.defaultConfigBuilder.withRetryPeriod(null)).build());
    }

    @Test
    void withConfigAndMissingLeaderCallbacksPeriodShouldThrowException() {
        this.assertRequiredField(((LeaderElectionConfigBuilder)this.defaultConfigBuilder.withLeaderCallbacks(null)).build());
    }

    @Test
    void withConfigAndMissingLockPeriodShouldThrowException() {
        this.assertRequiredField(((LeaderElectionConfigBuilder)this.defaultConfigBuilder.withLock(null)).build());
    }

    @Test
    void withConfigAndInvalidLeaseDurationComparedToRenewDeadlineShouldThrowException() {
        this.assertInvalidField(((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)this.defaultConfigBuilder.withLeaseDuration(Duration.ofSeconds(1L))).withRenewDeadline(Duration.ofSeconds(2L))).build());
    }

    @Test
    void withConfigAndInvalidRenewDeadlineComparedToRetryPeriodShouldThrowException() {
        this.assertInvalidField(((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)this.defaultConfigBuilder.withRenewDeadline(Duration.ofSeconds(1L))).withRetryPeriod(Duration.ofMillis(8000L))).build());
    }

    @Test
    void withConfigAndInvalidLeaseDurationShouldThrowException() {
        this.assertInvalidField(((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)this.defaultConfigBuilder.withLeaseDuration(Duration.ofNanos(15L))).withRenewDeadline(Duration.ofNanos(10L))).withRetryPeriod(Duration.ofNanos(2L))).build());
    }

    @Test
    void withConfigAndInvalidRenewDeadlineShouldThrowException() {
        this.assertInvalidField(((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)this.defaultConfigBuilder.withRenewDeadline(Duration.ofNanos(10L))).withRetryPeriod(Duration.ofNanos(2L))).build());
    }

    @Test
    void withConfigAndInvalidRetryPeriodShouldThrowException() {
        this.assertInvalidField(((LeaderElectionConfigBuilder)this.defaultConfigBuilder.withRetryPeriod(Duration.ofNanos(2L))).build());
    }

    private void assertRequiredField(LeaderElectionConfig invalidConfig) {
        Assertions.assertThrows(NullPointerException.class, () -> new LeaderElectorBuilder((KubernetesClient)this.mockKubernetesClient, (Executor)CommonThreadPool.get()).withConfig(invalidConfig).build());
    }

    private void assertInvalidField(LeaderElectionConfig invalidConfig) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LeaderElectorBuilder((KubernetesClient)this.mockKubernetesClient, (Executor)CommonThreadPool.get()).withConfig(invalidConfig).build());
    }
}

