/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.informers.cache.ReducedStateItemStore;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ReducedStateItemStoreTest {
    ReducedStateItemStoreTest() {
    }

    @Test
    void testStoreRestore() {
        ReducedStateItemStore store = new ReducedStateItemStore(ReducedStateItemStore.UID_KEY_STATE, Pod.class, new KubernetesSerialization(), new String[]{"metadata.labels", "foo.bar"});
        Pod pod = ((PodBuilder)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodBuilder)new PodBuilder().withNewSpec().endSpec()).withNewMetadata().withUid("x")).withName("y")).addToLabels("one", "1")).addToLabels("two", "2")).withResourceVersion("2")).endMetadata()).withNewStatus().endStatus()).build();
        Object[] values = store.store((HasMetadata)pod);
        Assertions.assertEquals((int)3, (int)values.length);
        Assertions.assertEquals((Object)"2", (Object)values[0]);
        Assertions.assertEquals((Object)pod.getMetadata().getLabels(), (Object)values[1]);
        Assert.assertNull((Object)values[2]);
        Pod restored = (Pod)store.restore("x", values);
        Assert.assertNull((Object)restored.getSpec());
        Assert.assertNull((Object)restored.getStatus());
        Assertions.assertEquals((Object)"x", (Object)restored.getMetadata().getUid());
        Assertions.assertEquals((Object)pod.getMetadata().getLabels(), (Object)restored.getMetadata().getLabels());
        Assert.assertNull((Object)store.put("x", (HasMetadata)pod));
        Assert.assertNotNull((Object)store.get("x"));
        Assertions.assertEquals((Object)"2", (Object)store.getResourceVersion("x"));
        Assertions.assertEquals((int)1, (int)store.size());
        Assert.assertNotNull((Object)store.remove("x"));
    }
}

