/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.BufferUtil;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.http.WebSocketUpgradeResponse;
import io.fabric8.kubernetes.client.utils.Utils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpLoggingInterceptor
implements Interceptor {
    private final HttpLogger httpLogger;

    public HttpLoggingInterceptor() {
        this(LoggerFactory.getLogger(HttpLoggingInterceptor.class));
    }

    public HttpLoggingInterceptor(Logger logger) {
        this.httpLogger = new HttpLogger(logger);
    }

    @Override
    public AsyncBody.Consumer<List<ByteBuffer>> consumer(AsyncBody.Consumer<List<ByteBuffer>> consumer, HttpRequest request) {
        return new DeferredLoggingConsumer(this.httpLogger, request, consumer);
    }

    @Override
    public void after(HttpRequest request, HttpResponse<?> response, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
        if (response instanceof WebSocketUpgradeResponse) {
            this.httpLogger.logWsStart();
            this.httpLogger.logRequest(request);
            this.httpLogger.logResponse(response);
            this.httpLogger.logWsEnd();
        } else {
            DeferredLoggingConsumer deferredLoggingConsumer = consumer.unwrap(DeferredLoggingConsumer.class);
            if (response.body() instanceof AsyncBody && deferredLoggingConsumer != null) {
                deferredLoggingConsumer.processAsyncBody((AsyncBody)response.body(), response);
            } else {
                this.httpLogger.logStart();
                this.httpLogger.logRequest(request);
                this.httpLogger.logResponse(response);
                this.httpLogger.logEnd();
            }
        }
    }

    private static final class HttpLogger {
        private final Logger logger;

        private HttpLogger(Logger logger) {
            this.logger = logger;
        }

        void logRequest(HttpRequest request) {
            if (this.logger.isTraceEnabled() && request != null) {
                this.logger.trace("> {} {}", (Object)request.method(), (Object)request.uri());
                request.headers().forEach((h, vv) -> vv.forEach(v -> this.logger.trace("> {}: {}", h, v)));
                if (!Utils.isNullOrEmpty(request.bodyString())) {
                    this.logger.trace(request.bodyString());
                }
            }
        }

        void logResponse(HttpResponse<?> response) {
            if (this.logger.isTraceEnabled() && response != null) {
                this.logger.trace("< {} {}", (Object)response.code(), (Object)response.message());
                response.headers().forEach((h, vv) -> vv.forEach(v -> this.logger.trace("< {}: {}", h, v)));
            }
        }

        void logResponseBody(Queue<ByteBuffer> responseBody) {
            if (this.logger.isTraceEnabled() && responseBody != null && !responseBody.isEmpty()) {
                StringBuilder bodyString = new StringBuilder();
                while (!responseBody.isEmpty()) {
                    bodyString.append(StandardCharsets.UTF_8.decode(responseBody.poll()));
                }
                if (bodyString.length() > 0) {
                    this.logger.trace(bodyString.toString());
                }
            }
        }

        void logStart() {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("-HTTP START-");
            }
        }

        void logEnd() {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("-HTTP END-");
            }
        }

        void logWsStart() {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("-WS START-");
            }
        }

        void logWsEnd() {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("-WS END-");
            }
        }
    }

    private static final class DeferredLoggingConsumer
    implements AsyncBody.Consumer<List<ByteBuffer>> {
        private static final long MAX_BODY_SIZE = 0x200000L;
        private final HttpLogger httpLogger;
        private final HttpRequest originalRequest;
        private final AsyncBody.Consumer<List<ByteBuffer>> originalConsumer;
        private final AtomicBoolean logResponseBody;
        private final AtomicLong responseBodySize;
        private final Queue<ByteBuffer> responseBody;

        public DeferredLoggingConsumer(HttpLogger httpLogger, HttpRequest originalRequest, AsyncBody.Consumer<List<ByteBuffer>> originalConsumer) {
            this.httpLogger = httpLogger;
            this.originalRequest = originalRequest;
            this.originalConsumer = originalConsumer;
            this.logResponseBody = new AtomicBoolean(true);
            this.responseBodySize = new AtomicLong(0L);
            this.responseBody = new ConcurrentLinkedQueue<ByteBuffer>();
        }

        @Override
        public void consume(List<ByteBuffer> value, AsyncBody asyncBody) throws Exception {
            if (!this.logResponseBody.get() || this.responseBodySize.get() > 0x200000L) {
                return;
            }
            if (!value.isEmpty()) {
                if (BufferUtil.isPlainText(value.iterator().next())) {
                    value.stream().map(BufferUtil::copy).forEach(bb -> {
                        if (this.responseBodySize.addAndGet(bb.remaining()) < 0x200000L) {
                            this.responseBody.add((ByteBuffer)bb);
                        }
                    });
                } else {
                    this.logResponseBody.set(false);
                }
            }
            this.originalConsumer.consume(value, asyncBody);
        }

        @Override
        public <U> U unwrap(Class<U> target) {
            return Optional.ofNullable(AsyncBody.Consumer.super.unwrap(target)).orElse(this.originalConsumer.unwrap(target));
        }

        private void processAsyncBody(AsyncBody asyncBody, HttpResponse<?> response) {
            asyncBody.done().whenComplete((v, throwable) -> {
                this.httpLogger.logStart();
                this.httpLogger.logRequest(this.originalRequest);
                this.httpLogger.logResponse(response);
                this.httpLogger.logResponseBody(this.responseBody);
                this.httpLogger.logEnd();
                this.responseBody.clear();
            });
        }
    }
}

