/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpLoggingInterceptor;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.DefaultMockServer;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.EventDoneable;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import io.fabric8.mockwebserver.dsl.WebSocketSessionBuilder;
import io.fabric8.mockwebserver.internal.SimpleRequest;
import io.fabric8.mockwebserver.utils.ResponseProviders;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import okio.Buffer;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public abstract class AbstractHttpLoggingInterceptorTest {
    private static DefaultMockServer server;
    private static Map<ServerRequest, Queue<ServerResponse>> responses;
    private Logger logger;
    private InOrder inOrder;
    private HttpClient httpClient;

    @BeforeAll
    static void beforeAll() {
        responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        server = new DefaultMockServer(new Context(), new MockWebServer(), responses, false);
        server.start();
    }

    @AfterAll
    static void afterAll() {
        server.shutdown();
    }

    @BeforeEach
    void setUp() {
        this.logger = (Logger)Mockito.mock(Logger.class);
        this.inOrder = Mockito.inOrder((Object[])new Object[]{this.logger});
        Mockito.when((Object)this.logger.isTraceEnabled()).thenReturn((Object)true);
        this.httpClient = this.getHttpClientFactory().newBuilder().addOrReplaceInterceptor("loggingInterceptor", (Interceptor)new HttpLoggingInterceptor(this.logger)).build();
    }

    protected abstract HttpClient.Factory getHttpClientFactory();

    @Test
    @DisplayName(value="HTTP request URI is logged")
    public void httpRequestUriLogged() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/request-uri")).andReturn(200, (Object)"This is the response body")).always();
        this.httpClient.sendAsync(this.httpClient.newHttpRequestBuilder().uri(server.url("/request-uri")).build(), String.class).get(10L, TimeUnit.SECONDS);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.timeout((long)1000L))).trace("-HTTP END-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-HTTP START-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace((String)ArgumentMatchers.eq((Object)"> {} {}"), ArgumentMatchers.eq((Object)"GET"), ArgumentMatchers.argThat(uri -> uri.toString().endsWith("/request-uri")));
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-HTTP END-");
    }

    @Test
    @DisplayName(value="HTTP request headers are logged")
    public void httpRequestHeadersLogged() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/request-headers")).andReturn(200, (Object)"This is the response body")).always();
        this.httpClient.sendAsync(this.httpClient.newHttpRequestBuilder().header("test-type", "header-test").uri(server.url("/request-headers")).build(), String.class).get(10L, TimeUnit.SECONDS);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.timeout((long)1000L))).trace("-HTTP END-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-HTTP START-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("> {}: {}", (Object)"test-type", (Object)"header-test");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-HTTP END-");
    }

    @Test
    @DisplayName(value="HTTP request body is logged")
    public void httpRequestBodyLogged() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/request-body")).andReturn(200, (Object)"This is the response body")).always();
        this.httpClient.sendAsync(this.httpClient.newHttpRequestBuilder().uri(server.url("/request-body")).method("POST", "test/plain", "This is the request body").build(), String.class).get(10L, TimeUnit.SECONDS);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.timeout((long)1000L))).trace("-HTTP END-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-HTTP START-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("This is the request body");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-HTTP END-");
    }

    @Test
    @DisplayName(value="HTTP response status is logged")
    public void httpResponseStatusLogged() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/response-status")).andReturn(200, (Object)"This is the response body")).always();
        this.httpClient.sendAsync(this.httpClient.newHttpRequestBuilder().uri(server.url("/response-status")).build(), String.class).get(10L, TimeUnit.SECONDS);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.timeout((long)1000L))).trace("-HTTP END-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-HTTP START-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("< {} {}", (Object)200, (Object)"OK");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-HTTP END-");
    }

    @Test
    @DisplayName(value="HTTP response headers are logged")
    public void httpResponseHeadersLogged() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/response-headers")).andReply(ResponseProviders.of((int)204, (Object)"", Collections.singletonMap("test-type", "response-header-test")))).always();
        this.httpClient.sendAsync(this.httpClient.newHttpRequestBuilder().uri(server.url("/response-headers")).build(), String.class).get(10L, TimeUnit.SECONDS);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.timeout((long)1000L))).trace("-HTTP END-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-HTTP START-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace((String)ArgumentMatchers.eq((Object)"< {} {}"), (Object)ArgumentMatchers.anyInt(), (Object)ArgumentMatchers.anyString());
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("< {}: {}", (Object)"test-type", (Object)"response-header-test");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-HTTP END-");
    }

    @Test
    @DisplayName(value="HTTP response body is logged")
    public void httpResponseBodyLogged() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/response-body")).andReturn(200, (Object)"This is the response body")).always();
        this.httpClient.sendAsync(this.httpClient.newHttpRequestBuilder().uri(server.url("/response-body")).build(), String.class).get(10L, TimeUnit.SECONDS);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.timeout((long)1000L))).trace("-HTTP END-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-HTTP START-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace((String)ArgumentMatchers.eq((Object)"< {} {}"), (Object)ArgumentMatchers.anyInt(), (Object)ArgumentMatchers.anyString());
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("This is the response body");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-HTTP END-");
    }

    @Test
    @DisplayName(value="HTTP binary response body is skipped")
    public void httpResponseBodySkipped() throws Exception {
        final MockResponse binaryResponse = new MockResponse().setResponseCode(200).setBody(new Buffer().write(new byte[]{-1, -40, 0, 18, 52}));
        responses.computeIfAbsent((ServerRequest)new SimpleRequest("/binary-response-body"), k -> new ArrayDeque()).add(new ServerResponse(){

            public boolean isRepeatable() {
                return true;
            }

            public MockResponse toMockResponse(RecordedRequest recordedRequest) {
                return binaryResponse;
            }
        });
        this.httpClient.sendAsync(this.httpClient.newHttpRequestBuilder().uri(server.url("/binary-response-body")).build(), String.class).get(10L, TimeUnit.SECONDS);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.timeout((long)1000L))).trace("-HTTP END-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-HTTP START-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace((String)ArgumentMatchers.eq((Object)"< {} {}"), (Object)ArgumentMatchers.anyInt(), (Object)ArgumentMatchers.anyString());
        ((Logger)this.inOrder.verify((Object)this.logger, Mockito.times((int)1))).trace(ArgumentMatchers.anyString());
        this.inOrder.verifyNoMoreInteractions();
    }

    @Test
    @DisplayName(value="WS request URI is logged")
    public void wsRequestUriLogged() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)server.expect().withPath("/ws-request-uri")).andUpgradeToWebSocket()).open(new Object[0])).done()).always();
        this.httpClient.newWebSocketBuilder().uri(URI.create(server.url("/ws-request-uri"))).buildAsync(new WebSocket.Listener(){}).get(10L, TimeUnit.SECONDS);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.timeout((long)1000L))).trace("-WS END-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-WS START-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace((String)ArgumentMatchers.eq((Object)"> {} {}"), ArgumentMatchers.eq((Object)"GET"), ArgumentMatchers.argThat(uri -> uri.toString().endsWith("/ws-request-uri")));
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-WS END-");
    }

    @Test
    @DisplayName(value="WS request headers are logged")
    public void wsRequestHeadersLogged() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)server.expect().withPath("/ws-request-headers")).andUpgradeToWebSocket()).open(new Object[0])).done()).always();
        this.httpClient.newWebSocketBuilder().header("test-type", "ws-header-test").uri(URI.create(server.url("/ws-request-headers"))).buildAsync(new WebSocket.Listener(){}).get(10L, TimeUnit.SECONDS);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.timeout((long)1000L))).trace("-WS END-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-WS START-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("> {}: {}", (Object)"test-type", (Object)"ws-header-test");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-WS END-");
    }

    @Test
    @DisplayName(value="WS response status is logged")
    public void wsResponseStatusLogged() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)server.expect().withPath("/ws-response-status")).andUpgradeToWebSocket()).open(new Object[0])).done()).always();
        this.httpClient.newWebSocketBuilder().uri(URI.create(server.url("/ws-response-status"))).buildAsync(new WebSocket.Listener(){}).get(10L, TimeUnit.SECONDS);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.timeout((long)1000L))).trace("-WS END-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-WS START-");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("< {} {}", (Object)101, (Object)"Switching Protocols");
        ((Logger)this.inOrder.verify((Object)this.logger)).trace("-WS END-");
    }
}

