/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.RequestConfigBuilder;
import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.TestHttpResponse;
import io.fabric8.kubernetes.client.http.TestStandardHttpClient;
import io.fabric8.kubernetes.client.http.TestStandardHttpClientFactory;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import io.fabric8.kubernetes.client.http.WebSocketUpgradeResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class StandardHttpClientTest {
    private TestStandardHttpClient client;

    StandardHttpClientTest() {
    }

    @BeforeEach
    void setup() {
        this.client = new TestStandardHttpClientFactory().newBuilder().build();
    }

    @Test
    void webSocketFutureCancel() {
        CompletableFuture future = this.client.newWebSocketBuilder().uri(URI.create("ws://localhost")).buildAsync(new WebSocket.Listener(){});
        WebSocket ws = (WebSocket)Mockito.mock(WebSocket.class);
        future.cancel(true);
        this.client.getWsFutures().get(0).complete(new WebSocketResponse(new WebSocketUpgradeResponse(null, 101), ws));
        ((WebSocket)Mockito.verify((Object)ws)).sendClose(1000, null);
    }

    @Test
    void consumeBytesFutureCancel() {
        TestHttpResponse<Object> asyncResp = new TestHttpResponse<Object>().withBody(Mockito.mock(AsyncBody.class));
        CompletableFuture consumeFuture = this.client.consumeBytes(this.client.newHttpRequestBuilder().uri("http://localhost").build(), (value, asyncBody) -> {});
        consumeFuture.cancel(true);
        this.client.getRespFutures().get(0).complete(asyncResp);
        ((AsyncBody)Mockito.verify((Object)asyncResp.body())).cancel();
    }

    @Test
    void sendAsyncFutureCancel() {
        TestHttpResponse<Object> asyncResp = new TestHttpResponse<Object>().withBody(Mockito.mock(AsyncBody.class));
        Mockito.when((Object)((AsyncBody)asyncResp.body()).done()).thenReturn(new CompletableFuture());
        CompletableFuture sendAsyncFuture = this.client.sendAsync(this.client.newHttpRequestBuilder().uri("http://localhost").build(), InputStream.class);
        sendAsyncFuture.cancel(true);
        this.client.getRespFutures().get(0).complete(asyncResp);
        ((AsyncBody)Mockito.verify((Object)asyncResp.body())).cancel();
    }

    @Test
    void test10RetriesWithDefaultConfig() throws Exception {
        CompletableFuture sendAsyncFuture = this.client.sendAsync(this.client.newHttpRequestBuilder().uri("http://localhost").build(), InputStream.class);
        this.client.getRespFutures().get(0).completeExceptionally(new IOException());
        IntStream.range(1, 11).forEach(i -> this.client.getRespFutures().add(this.client.getRespFutures().get(0)));
        try {
            sendAsyncFuture.get(30L, TimeUnit.SECONDS);
            Assertions.fail();
        }
        catch (ExecutionException e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
    }

    @Test
    void testHttpRetryWithMoreFailuresThanRetries() throws Exception {
        this.client = this.client.newBuilder().tag(((RequestConfigBuilder)((RequestConfigBuilder)new RequestConfigBuilder().withRequestRetryBackoffLimit(3)).withRequestRetryBackoffInterval(50)).build()).build();
        CompletableFuture consumeFuture = this.client.consumeBytes(this.client.newHttpRequestBuilder().uri("http://localhost").build(), (value, asyncBody) -> {});
        long start = System.currentTimeMillis();
        this.client.getRespFutures().get(0).completeExceptionally(new IOException());
        this.client.getRespFutures().add(this.client.getRespFutures().get(0));
        this.client.getRespFutures().add(this.client.getRespFutures().get(0));
        this.client.getRespFutures().add(CompletableFuture.completedFuture(new TestHttpResponse().withCode(500)));
        Assertions.assertEquals((int)500, (int)((HttpResponse)consumeFuture.get()).code());
        long stop = System.currentTimeMillis();
        Assertions.assertTrue((stop - start >= 350L ? 1 : 0) != 0);
        Assertions.assertEquals((int)4, (int)this.client.getRespFutures().size());
    }

    @Test
    void testHttpRetryWithLessFailuresThanRetries() throws Exception {
        this.client = this.client.newBuilder().tag(((RequestConfigBuilder)((RequestConfigBuilder)new RequestConfigBuilder().withRequestRetryBackoffLimit(3)).withRequestRetryBackoffInterval(50)).build()).build();
        TestHttpResponse<Object> error = new TestHttpResponse<Object>().withBody(Mockito.mock(AsyncBody.class)).withCode(500);
        this.client.getRespFutures().add(CompletableFuture.completedFuture(error));
        this.client.getRespFutures().add(CompletableFuture.completedFuture(error));
        this.client.getRespFutures().add(CompletableFuture.completedFuture(error));
        this.client.getRespFutures().add(CompletableFuture.completedFuture(new TestHttpResponse().withCode(200)));
        CompletableFuture consumeFuture = this.client.consumeBytes(this.client.newHttpRequestBuilder().uri("http://localhost").build(), (value, asyncBody) -> {});
        Assertions.assertEquals((int)200, (int)((HttpResponse)consumeFuture.get(2L, TimeUnit.MINUTES)).code());
        Assertions.assertEquals((int)4, (int)this.client.getRespFutures().size());
    }

    @Test
    void testWebSocketWithLessFailuresThanRetries() throws Exception {
        this.client = this.client.newBuilder().tag(((RequestConfigBuilder)((RequestConfigBuilder)new RequestConfigBuilder().withRequestRetryBackoffLimit(3)).withRequestRetryBackoffInterval(50)).build()).build();
        WebSocket ws = (WebSocket)Mockito.mock(WebSocket.class);
        CompletableFuture future = this.client.newWebSocketBuilder().uri(URI.create("ws://localhost")).buildAsync(new WebSocket.Listener(){});
        this.client.getWsFutures().get(0).complete(new WebSocketResponse(new WebSocketUpgradeResponse(null, 500, null), (Throwable)new IOException()));
        this.client.getWsFutures().add(this.client.getWsFutures().get(0));
        this.client.getWsFutures().add(CompletableFuture.completedFuture(new WebSocketResponse(new WebSocketUpgradeResponse(null), ws)));
        future.get(2L, TimeUnit.MINUTES);
        Assertions.assertEquals((int)3, (int)this.client.getWsFutures().size());
    }

    @Test
    void testClosePreviousBeforeRetry() throws Exception {
        this.client = this.client.newBuilder().tag(((RequestConfigBuilder)((RequestConfigBuilder)new RequestConfigBuilder().withRequestRetryBackoffLimit(1)).withRequestRetryBackoffInterval(50)).build()).build();
        TestHttpResponse<Object> error = new TestHttpResponse<Object>().withBody(Mockito.mock(AsyncBody.class)).withCode(503);
        this.client.getRespFutures().add(CompletableFuture.completedFuture(error));
        this.client.getRespFutures().add(CompletableFuture.completedFuture(new TestHttpResponse().withCode(200)));
        CompletableFuture consumeFuture = this.client.consumeBytes(this.client.newHttpRequestBuilder().uri("http://localhost").build(), (value, asyncBody) -> {});
        ((AsyncBody)Mockito.verify((Object)error.body())).cancel();
        Assertions.assertEquals((int)200, (int)((HttpResponse)consumeFuture.get(2L, TimeUnit.MINUTES)).code());
        Assertions.assertEquals((int)2, (int)this.client.getRespFutures().size());
    }
}

