/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.mockwebserver.DefaultMockServer;
import io.fabric8.mockwebserver.dsl.EventDoneable;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import io.fabric8.mockwebserver.dsl.TimesOrOnceable;
import io.fabric8.mockwebserver.dsl.WebSocketSessionBuilder;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public abstract class AbstractWebSocketSendTest {
    private static DefaultMockServer server;

    @BeforeAll
    static void beforeAll() {
        server = new DefaultMockServer(false);
        server.start();
    }

    @AfterAll
    static void afterAll() {
        server.shutdown();
    }

    protected abstract HttpClient.Factory getHttpClientFactory();

    @Test
    @DisplayName(value="send, emits a message to the server (the server responds to this message)")
    void sendEmitsMessageToWebSocketServer() throws Exception {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            ((TimesOnceableOrHttpHeaderable)((EventDoneable)((TimesOrOnceable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)server.expect().withPath("/send-text")).andUpgradeToWebSocket()).open(new Object[0])).expect((Object)"GiveMeSomething").andEmit((Object)"received")).always()).done()).always();
            final ArrayBlockingQueue receivedText = new ArrayBlockingQueue(1);
            WebSocket ws = (WebSocket)client.newBuilder().readTimeout(0L, TimeUnit.SECONDS).build().newWebSocketBuilder().uri(URI.create(server.url("send-text"))).buildAsync(new WebSocket.Listener(){

                public void onMessage(WebSocket webSocket, String text) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)receivedText.offer(text));
                }
            }).get(10L, TimeUnit.SECONDS);
            ws.send(ByteBuffer.wrap("GiveMeSomething".getBytes(StandardCharsets.UTF_8)));
            String result = (String)receivedText.poll(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)result).isEqualTo("received");
        }
    }
}

