/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.TestHttpResponse;
import io.fabric8.kubernetes.client.utils.TokenRefreshInterceptor;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class TokenRefreshInterceptorTest {
    TokenRefreshInterceptorTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldAutoconfigureAfter401() throws Exception {
        try {
            File tempFile = Files.createTempFile("test", "kubeconfig", new FileAttribute[0]).toFile();
            Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/token-refresh-interceptor/kubeconfig")), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            System.setProperty("kubeconfig", tempFile.getAbsolutePath());
            HttpRequest.Builder builder = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Mockito.RETURNS_SELF);
            boolean reissue = (Boolean)new TokenRefreshInterceptor(Config.autoConfigure(null), null, Instant.now()).afterFailure(builder, new TestHttpResponse().withCode(401), null).get();
            ((HttpRequest.Builder)Mockito.verify((Object)builder)).setHeader("Authorization", "Bearer token");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reissue);
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldAutoconfigureAfter1Minute() throws Exception {
        try {
            File tempFile = Files.createTempFile("test", "kubeconfig", new FileAttribute[0]).toFile();
            Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/token-refresh-interceptor/kubeconfig")), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            System.setProperty("kubeconfig", tempFile.getAbsolutePath());
            HttpRequest.Builder builder = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Mockito.RETURNS_SELF);
            TokenRefreshInterceptor tokenRefreshInterceptor = new TokenRefreshInterceptor(Config.autoConfigure(null), null, Instant.now().minus(61L, ChronoUnit.SECONDS));
            Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/token-refresh-interceptor/kubeconfig.new")), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            tokenRefreshInterceptor.before((BasicBuilder)builder, null, null);
            ((HttpRequest.Builder)Mockito.verify((Object)builder)).setHeader("Authorization", "Bearer new token");
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    @DisplayName(value="#4442 token auto refresh should not overwrite existing token when not applicable")
    void refreshShouldNotOverwriteExistingToken() throws Exception {
        Config originalConfig = (Config)Mockito.spy((Object)((ConfigBuilder)new ConfigBuilder(Config.empty()).withOauthToken("existing-token")).build());
        Config autoConfig = ((ConfigBuilder)new ConfigBuilder(Config.empty()).withOauthToken("")).build();
        Mockito.when((Object)originalConfig.refresh()).thenReturn((Object)autoConfig);
        TokenRefreshInterceptor tokenRefreshInterceptor = new TokenRefreshInterceptor(originalConfig, null, Instant.now().minusSeconds(61L));
        boolean result = (Boolean)tokenRefreshInterceptor.afterFailure((HttpRequest.Builder)new StandardHttpRequest.Builder(), new TestHttpResponse().withCode(401), null).get();
        Assertions.assertThat((boolean)result).isFalse();
        Assertions.assertThat((Object)originalConfig).hasFieldOrPropertyWithValue("oauthToken", (Object)"existing-token");
    }

    @Test
    @DisplayName(value="#4442 token auto refresh should  overwrite existing token when applicable")
    void refreshShouldOverwriteExistingToken() throws Exception {
        Config originalConfig = (Config)Mockito.spy((Object)((ConfigBuilder)new ConfigBuilder(Config.empty()).withOauthToken("existing-token")).build());
        Config autoConfig = ((ConfigBuilder)new ConfigBuilder(Config.empty()).withOauthToken("new-token")).build();
        Mockito.when((Object)originalConfig.refresh()).thenReturn((Object)autoConfig);
        TokenRefreshInterceptor tokenRefreshInterceptor = new TokenRefreshInterceptor(originalConfig, null, Instant.now().minusSeconds(61L));
        boolean result = (Boolean)tokenRefreshInterceptor.afterFailure((HttpRequest.Builder)new StandardHttpRequest.Builder(), new TestHttpResponse().withCode(401), null).get();
        Assertions.assertThat((boolean)result).isTrue();
        Assertions.assertThat((Object)originalConfig).hasFieldOrPropertyWithValue("oauthToken", (Object)"new-token");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldReloadInClusterServiceAccount() throws Exception {
        try {
            File tokenFile = Files.createTempFile("test", "token", new FileAttribute[0]).toFile();
            Files.write(tokenFile.toPath(), "expired".getBytes(), new OpenOption[0]);
            System.setProperty("kubernetes.auth.serviceAccount.token", tokenFile.getAbsolutePath());
            System.setProperty("kubernetes.auth.tryKubeConfig", "false");
            HttpRequest.Builder builder = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Mockito.RETURNS_SELF);
            TokenRefreshInterceptor interceptor = new TokenRefreshInterceptor(Config.autoConfigure(null), null, Instant.now());
            Files.write(tokenFile.toPath(), "renewed".getBytes(), new OpenOption[0]);
            boolean reissue = (Boolean)interceptor.afterFailure(builder, new TestHttpResponse().withCode(401), null).get();
            ((HttpRequest.Builder)Mockito.verify((Object)builder)).setHeader("Authorization", "Bearer renewed");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reissue);
        }
        finally {
            System.clearProperty("kubernetes.auth.serviceAccount.token");
            System.clearProperty("kubernetes.auth.tryKubeConfig");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldRefreshOIDCToken() throws Exception {
        try {
            File tempFile = Files.createTempFile("test", "kubeconfig", new FileAttribute[0]).toFile();
            Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/token-refresh-interceptor/kubeconfig-oidc")), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            System.setProperty("kubeconfig", tempFile.getAbsolutePath());
            HttpRequest.Builder builder = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Mockito.RETURNS_SELF);
            Config config = Config.autoConfigure(null);
            Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/token-refresh-interceptor/kubeconfig-oidc")), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            TokenRefreshInterceptor interceptor = new TokenRefreshInterceptor(config, (HttpClient.Factory)Mockito.mock(HttpClient.Factory.class), Instant.now());
            boolean reissue = (Boolean)interceptor.afterFailure(builder, new TestHttpResponse().withCode(401), null).get();
            ((HttpRequest.Builder)Mockito.verify((Object)builder)).setHeader("Authorization", "Bearer renewed");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)reissue);
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }
}

