/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.client.utils.ResourceCompare;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ResourceCompareTest {
    private Pod pod;
    private Service service;
    private KubernetesList kubeList;

    ResourceCompareTest() {
    }

    @BeforeEach
    public void setup() {
        this.pod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).withLabels(Collections.singletonMap("label", "value"))).and()).build();
        this.service = ((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("service1")).withNamespace("test")).and()).build();
        ReplicationController rc = ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl1")).withNamespace("test")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).endSpec()).build();
        this.kubeList = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(new HasMetadata[]{this.pod, this.service, rc})).build();
    }

    @Test
    void testResourceCompareEqualsTrue() {
        MatcherAssert.assertThat((Object)ResourceCompare.equals((Object)this.kubeList, (Object)this.kubeList), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void testResourceCompareEqualsFalse() {
        ReplicationController rc = ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl1")).withNamespace("test")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(2))).endSpec()).build();
        KubernetesList kubeList2 = ((KubernetesListBuilder)new KubernetesListBuilder(this.kubeList).withItems(new HasMetadata[]{this.pod, this.service, rc})).build();
        MatcherAssert.assertThat((Object)ResourceCompare.equals((Object)this.kubeList, (Object)kubeList2), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    void testPodResourceCompareEqualsTrueNoLabels() {
        Pod podNoLabels = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).and()).build();
        MatcherAssert.assertThat((Object)ResourceCompare.equals((Object)this.pod, (Object)podNoLabels), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void testPodResourceCompareEqualsTrueMatchingLabels() {
        Pod podWithLabels = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).withLabels(Collections.singletonMap("label", "value"))).and()).build();
        MatcherAssert.assertThat((Object)ResourceCompare.equals((Object)this.pod, (Object)podWithLabels), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void testPodResourceCompareEqualsFalseDifferentLabels() {
        Pod podWithLabels = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).withLabels(Collections.singletonMap("label", "another value"))).and()).build();
        MatcherAssert.assertThat((Object)ResourceCompare.equals((Object)this.pod, (Object)podWithLabels), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    void testServiceDifferenceFromClusterAndAsObject() {
        Service serviceFromCluster = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withCreationTimestamp("2020-07-27T10:36:33Z")).withName("my-service")).withNamespace("default")).withResourceVersion("202998")).withSelfLink("/api/v1/namespaces/default/services/my-service")).withUid("99fe3964-b53b-473f-b1d8-bdb0390d1634")).endMetadata()).withNewSpec().withClusterIP("10.110.153.70")).addNewPort().withPort(Integer.valueOf(80))).withProtocol("TCP")).withTargetPort(new IntOrString((Object)"9376"))).endPort()).addToSelector(Collections.singletonMap("app", "MyApp"))).withType("ClusterIP")).endSpec()).build();
        Service serviceAsObj = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("my-service")).endMetadata()).withNewSpec().addToSelector(Collections.singletonMap("app", "MyApp"))).addNewPort().withPort(Integer.valueOf(80))).withProtocol("TCP")).withTargetPort(new IntOrString((Object)"9376"))).endPort()).endSpec()).build();
        boolean result = ResourceCompare.equals((Object)serviceFromCluster, (Object)serviceAsObj);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void testEqualsWhenOneResourceIsNull() {
        Pod pod2 = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("foo")).endMetadata()).build();
        boolean result = ResourceCompare.equals(null, (Object)pod2);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testEqualsWhenBothNull() {
        Assertions.assertTrue((boolean)ResourceCompare.equals(null, null));
    }

    @Test
    void testMetadataChanged() {
        Assertions.assertFalse((boolean)ResourceCompare.metadataChanged((ObjectMeta)((ObjectMetaBuilder)new ObjectMetaBuilder().withResourceVersion("1")).build(), (ObjectMeta)((ObjectMetaBuilder)new ObjectMetaBuilder().withResourceVersion("2")).build()));
    }
}

