/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.StandardHttpClient;
import io.fabric8.kubernetes.client.http.StandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.StandardWebSocketBuilder;
import io.fabric8.kubernetes.client.http.TestStandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.TestStandardHttpClientFactory;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class TestStandardHttpClient
extends StandardHttpClient<TestStandardHttpClient, TestStandardHttpClientFactory, TestStandardHttpClientBuilder> {
    private final List<CompletableFuture<WebSocketResponse>> wsFutures = new ArrayList<CompletableFuture<WebSocketResponse>>();
    private int wsIndex;
    private final List<CompletableFuture<HttpResponse<AsyncBody>>> respFutures = new ArrayList<CompletableFuture<HttpResponse<AsyncBody>>>();
    private int respIndex;

    protected TestStandardHttpClient(TestStandardHttpClientBuilder builder) {
        super((StandardHttpClientBuilder)builder);
    }

    public void close() {
        this.wsFutures.clear();
        this.respFutures.clear();
    }

    public synchronized CompletableFuture<WebSocketResponse> buildWebSocketDirect(StandardWebSocketBuilder standardWebSocketBuilder, WebSocket.Listener listener) {
        if (this.wsFutures.size() <= this.wsIndex) {
            this.wsFutures.add(new CompletableFuture());
        }
        return this.wsFutures.get(this.wsIndex++);
    }

    public synchronized CompletableFuture<HttpResponse<AsyncBody>> consumeBytesDirect(StandardHttpRequest request, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
        if (this.respFutures.size() <= this.respIndex) {
            this.respFutures.add(new CompletableFuture());
        }
        return this.respFutures.get(this.respIndex++);
    }

    public TestStandardHttpClientBuilder newBuilder() {
        return (TestStandardHttpClientBuilder)super.newBuilder();
    }

    public List<CompletableFuture<WebSocketResponse>> getWsFutures() {
        return this.wsFutures;
    }

    public List<CompletableFuture<HttpResponse<AsyncBody>>> getRespFutures() {
        return this.respFutures;
    }
}

