/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.mockwebserver.DefaultMockServer;
import io.fabric8.mockwebserver.dsl.EventDoneable;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import io.fabric8.mockwebserver.dsl.WebSocketSessionBuilder;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public abstract class AbstractInterceptorTest {
    private static DefaultMockServer server;

    @BeforeEach
    void startServer() {
        server = new DefaultMockServer(false);
        server.start();
    }

    @AfterEach
    void stopServer() {
        server.shutdown();
    }

    protected abstract HttpClient.Factory getHttpClientFactory();

    @Test
    @DisplayName(value="before (HTTP), should add a header to the HTTP request")
    public void beforeHttpAddsHeaderToRequest() throws Exception {
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().addOrReplaceInterceptor("test", new Interceptor(){

            public void before(BasicBuilder builder, HttpRequest request, Interceptor.RequestTags tags) {
                builder.header("Test-Header", "Test-Value");
            }
        });
        try (HttpClient client = builder.build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/intercept-before")).build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        Assertions.assertThat((Map)server.getLastRequest().getHeaders().toMultimap()).containsEntry((Object)"test-header", Collections.singletonList("Test-Value"));
    }

    @Test
    @DisplayName(value="before (HTTP), should modify the HTTP request URI")
    public void beforeHttpModifiesRequestUri() throws Exception {
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().addOrReplaceInterceptor("test", new Interceptor(){

            public void before(BasicBuilder builder, HttpRequest request, Interceptor.RequestTags tags) {
                builder.uri(URI.create(server.url("valid-url")));
            }
        });
        try (HttpClient client = builder.build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/invalid-url")).build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        Assertions.assertThat((int)server.getRequestCount()).isEqualTo(1);
        Assertions.assertThat((String)server.getLastRequest().getPath()).isEqualTo("/valid-url");
    }

    @Test
    @DisplayName(value="before (WS), should add a header to the HTTP request")
    public void beforeWsAddsHeaderToRequest() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)server.expect().withPath("/intercept-before")).andUpgradeToWebSocket()).open(new Object[0])).done()).always();
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().addOrReplaceInterceptor("test", new Interceptor(){

            public void before(BasicBuilder builder, HttpRequest request, Interceptor.RequestTags tags) {
                builder.header("Test-Header", "Test-Value");
            }
        });
        try (HttpClient client = builder.build();){
            client.newWebSocketBuilder().uri(URI.create(server.url("intercept-before"))).buildAsync(new WebSocket.Listener(){}).get(10L, TimeUnit.SECONDS);
        }
        Assertions.assertThat((Map)server.getLastRequest().getHeaders().toMultimap()).containsEntry((Object)"test-header", Collections.singletonList("Test-Value"));
    }

    @Test
    @DisplayName(value="before (WS), should modify the HTTP request URI")
    public void beforeWsModifiesRequestUri() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)server.expect().withPath("/valid-url")).andUpgradeToWebSocket()).open(new Object[0])).done()).always();
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().addOrReplaceInterceptor("test", new Interceptor(){

            public void before(BasicBuilder builder, HttpRequest request, Interceptor.RequestTags tags) {
                builder.uri(URI.create(server.url("valid-url")));
            }
        });
        try (HttpClient client = builder.build();){
            client.newWebSocketBuilder().uri(URI.create(server.url("invalid-url"))).buildAsync(new WebSocket.Listener(){}).get(10L, TimeUnit.SECONDS);
        }
        Assertions.assertThat((int)server.getRequestCount()).isEqualTo(1);
        Assertions.assertThat((String)server.getLastRequest().getPath()).isEqualTo("/valid-url");
    }

    @Test
    @DisplayName(value="afterFailure (HTTP), replaces the HttpResponse produced by HttpClient.sendAsync")
    public void afterHttpFailureReplacesResponseInSendAsync() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/intercepted-url")).andReturn(200, (Object)"This works")).once();
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().addOrReplaceInterceptor("test", new Interceptor(){

            public CompletableFuture<Boolean> afterFailure(BasicBuilder builder, HttpResponse<?> response, Interceptor.RequestTags tags) {
                builder.uri(URI.create(server.url("/intercepted-url")));
                return CompletableFuture.completedFuture(true);
            }
        });
        try (HttpClient client = builder.build();){
            HttpResponse result = (HttpResponse)client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/not-found")).build(), String.class).get(10L, TimeUnit.SECONDS);
            ((ObjectAssert)Assertions.assertThat((Object)result).returns((Object)"This works", HttpResponse::body)).returns((Object)200, HttpResponse::code);
        }
    }

    @Test
    @DisplayName(value="afterFailure (HTTP), replaces the HttpResponse produced by HttpClient.consumeBytes")
    public void afterHttpFailureReplacesResponseInConsumeBytes() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/intercepted-url")).andReturn(200, (Object)"This works")).once();
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().addOrReplaceInterceptor("test", new Interceptor(){

            public CompletableFuture<Boolean> afterFailure(BasicBuilder builder, HttpResponse<?> response, Interceptor.RequestTags tags) {
                builder.uri(URI.create(server.url("/intercepted-url")));
                return CompletableFuture.completedFuture(true);
            }
        });
        CompletableFuture result = new CompletableFuture();
        try (HttpClient client = builder.build();){
            HttpResponse asyncR = (HttpResponse)client.consumeBytes(client.newHttpRequestBuilder().uri(server.url("/not-found")).build(), (s, ab) -> {
                result.complete(StandardCharsets.UTF_8.decode((ByteBuffer)s.iterator().next()).toString());
                ab.consume();
            }).get(10L, TimeUnit.SECONDS);
            ((AsyncBody)asyncR.body()).consume();
            ((AsyncBody)asyncR.body()).done().get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)result.get())).isEqualTo("This works");
        }
    }

    @Test
    @DisplayName(value="afterFailure (HTTP), previous consumed response bodies are closed")
    public void afterHttpFailurePreviousResponsesAreClosed() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/intercepted-url")).andReturn(200, (Object)"This works")).once();
        final ConcurrentHashMap.KeySetView interceptedResponses = ConcurrentHashMap.newKeySet();
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().addOrReplaceInterceptor("invalid-url", new Interceptor(){

            public CompletableFuture<Boolean> afterFailure(BasicBuilder builder, HttpResponse<?> response, Interceptor.RequestTags tags) {
                builder.uri(URI.create(server.url("/still-not-found")));
                interceptedResponses.add(response);
                return CompletableFuture.completedFuture(true);
            }
        }).addOrReplaceInterceptor("valid-url", new Interceptor(){

            public CompletableFuture<Boolean> afterFailure(BasicBuilder builder, HttpResponse<?> response, Interceptor.RequestTags tags) {
                builder.uri(URI.create(server.url("/intercepted-url")));
                interceptedResponses.add(response);
                return CompletableFuture.completedFuture(true);
            }
        });
        try (HttpClient client = builder.build();){
            client.consumeBytes(client.newHttpRequestBuilder().uri(server.url("/not-found")).build(), (s, ab) -> ab.consume()).get(10L, TimeUnit.SECONDS);
        }
        ((AbstractCollectionAssert)Assertions.assertThat(interceptedResponses).hasSize(2)).extracting(r -> ((AsyncBody)r.body()).done().isDone()).containsOnly((Object[])new Boolean[]{true, true});
    }

    @Test
    @DisplayName(value="afterFailure (WS), replaces the URL and returns true, should reconnect to valid URL")
    public void afterWSFailureTODOReplacesResponseInSendAsync() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)server.expect().withPath("/valid-url")).andUpgradeToWebSocket()).open(new Object[0])).done()).always();
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().addOrReplaceInterceptor("test", new Interceptor(){

            public CompletableFuture<Boolean> afterFailure(BasicBuilder builder, HttpResponse<?> response, Interceptor.RequestTags tags) {
                builder.uri(URI.create(server.url("valid-url")));
                return CompletableFuture.completedFuture(true);
            }
        });
        try (HttpClient client = builder.build();){
            client.newWebSocketBuilder().uri(URI.create(server.url("invalid-url"))).buildAsync(new WebSocket.Listener(){}).get(10L, TimeUnit.SECONDS);
        }
        Assertions.assertThat((int)server.getRequestCount()).isEqualTo(2);
        Assertions.assertThat((String)server.getLastRequest().getPath()).isEqualTo("/valid-url");
    }

    @Test
    @DisplayName(value="interceptors (HTTP) should be applied in the order they were added")
    public void interceptorsHttpAreAppliedInOrder() throws Exception {
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().addOrReplaceInterceptor("first", new Interceptor(){

            public void before(BasicBuilder builder, HttpRequest request, Interceptor.RequestTags tags) {
                builder.header("Test-Header", "Test-Value");
            }
        }).addOrReplaceInterceptor("second", new Interceptor(){

            public void before(BasicBuilder builder, HttpRequest request, Interceptor.RequestTags tags) {
                builder.setHeader("Test-Header", "Test-Value-Override");
            }
        });
        try (HttpClient client = builder.build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/intercept-before")).build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        Assertions.assertThat((Map)server.getLastRequest().getHeaders().toMultimap()).containsEntry((Object)"test-header", Collections.singletonList("Test-Value-Override"));
    }

    @Test
    @DisplayName(value="interceptors (WS) should be applied in the order they were added")
    public void interceptorWssAreAppliedInOrder() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)server.expect().withPath("/intercept-before")).andUpgradeToWebSocket()).open(new Object[0])).done()).always();
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().addOrReplaceInterceptor("first", new Interceptor(){

            public void before(BasicBuilder builder, HttpRequest request, Interceptor.RequestTags tags) {
                builder.header("Test-Header", "Test-Value");
            }
        }).addOrReplaceInterceptor("second", new Interceptor(){

            public void before(BasicBuilder builder, HttpRequest request, Interceptor.RequestTags tags) {
                builder.setHeader("Test-Header", "Test-Value-Override");
            }
        });
        try (HttpClient client = builder.build();){
            client.newWebSocketBuilder().uri(URI.create(server.url("intercept-before"))).buildAsync(new WebSocket.Listener(){}).get(10L, TimeUnit.SECONDS);
        }
        Assertions.assertThat((Map)server.getLastRequest().getHeaders().toMultimap()).containsEntry((Object)"test-header", Collections.singletonList("Test-Value-Override"));
    }
}

