/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.utils.CachedSingleThreadScheduler;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CachedSingleThreadSchedulerTest {
    CachedSingleThreadSchedulerTest() {
    }

    @Test
    void testAutoShutdown() throws InterruptedException {
        CachedSingleThreadScheduler scheduler = new CachedSingleThreadScheduler(50L);
        Assertions.assertFalse((boolean)scheduler.hasExecutor());
        CountDownLatch latch = new CountDownLatch(2);
        ScheduledFuture future = scheduler.scheduleWithFixedDelay(latch::countDown, 50L, 50L, TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)scheduler.hasExecutor());
        latch.await();
        Assertions.assertFalse((boolean)future.isDone());
        future.cancel(true);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> !scheduler.hasExecutor());
        future = scheduler.scheduleWithFixedDelay(latch::countDown, 50L, 50L, TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)scheduler.hasExecutor());
    }
}

