/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.StandardHttpClient;
import io.fabric8.kubernetes.client.http.StandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.StandardWebSocketBuilder;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class StandardHttpClientTest {
    private TestableStandardHttpClient client = new TestableStandardHttpClient();

    StandardHttpClientTest() {
    }

    @Test
    void webSocketFutureCancel() {
        CompletableFuture future = this.client.newWebSocketBuilder().uri(URI.create("ws://localhost")).buildAsync(new WebSocket.Listener(){});
        WebSocket ws = (WebSocket)Mockito.mock(WebSocket.class);
        future.cancel(true);
        this.client.wsFuture.complete(new WebSocketResponse(ws, null));
        ((WebSocket)Mockito.verify((Object)ws)).sendClose(1000, null);
    }

    @Test
    void consumeBytesFutureCancel() {
        HttpResponse asyncResp = (HttpResponse)Mockito.mock(HttpResponse.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)asyncResp.body()).thenReturn(Mockito.mock(AsyncBody.class));
        CompletableFuture consumeFuture = this.client.consumeBytes(this.client.newHttpRequestBuilder().uri("http://localhost").build(), (AsyncBody.Consumer)new AsyncBody.Consumer<List<ByteBuffer>>(){

            public void consume(List<ByteBuffer> value, AsyncBody asyncBody) throws Exception {
            }
        });
        consumeFuture.cancel(true);
        this.client.respFuture.complete((HttpResponse<AsyncBody>)asyncResp);
        ((AsyncBody)Mockito.verify((Object)asyncResp.body())).cancel();
    }

    @Test
    void sendAsyncFutureCancel() {
        HttpResponse asyncResp = (HttpResponse)Mockito.mock(HttpResponse.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)asyncResp.body()).thenReturn(Mockito.mock(AsyncBody.class));
        Mockito.when((Object)((AsyncBody)asyncResp.body()).done()).thenReturn(new CompletableFuture());
        CompletableFuture sendAsyncFuture = this.client.sendAsync(this.client.newHttpRequestBuilder().uri("http://localhost").build(), InputStream.class);
        sendAsyncFuture.cancel(true);
        this.client.respFuture.complete((HttpResponse<AsyncBody>)asyncResp);
        ((AsyncBody)Mockito.verify((Object)asyncResp.body())).cancel();
    }

    private static final class TestableStandardHttpClient
    extends StandardHttpClient<HttpClient, HttpClient.Factory, StandardHttpClientBuilder<HttpClient, HttpClient.Factory, ?>> {
        CompletableFuture<WebSocketResponse> wsFuture;
        CompletableFuture<HttpResponse<AsyncBody>> respFuture;

        private TestableStandardHttpClient() {
            super((StandardHttpClientBuilder)Mockito.mock(StandardHttpClientBuilder.class));
        }

        public void close() {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<WebSocketResponse> buildWebSocketDirect(StandardWebSocketBuilder standardWebSocketBuilder, WebSocket.Listener listener) {
            this.wsFuture = new CompletableFuture();
            return this.wsFuture;
        }

        public CompletableFuture<HttpResponse<AsyncBody>> consumeBytesDirect(StandardHttpRequest request, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
            this.respFuture = new CompletableFuture();
            return this.respFuture;
        }
    }
}

