/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.mockwebserver.DefaultMockServer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import okhttp3.mockwebserver.RecordedRequest;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public abstract class AbstractHttpPostTest {
    private static DefaultMockServer server;

    @BeforeAll
    static void beforeAll() {
        server = new DefaultMockServer(false);
        server.start();
    }

    @AfterAll
    static void afterAll() {
        server.shutdown();
    }

    protected abstract HttpClient.Factory getHttpClientFactory();

    @Test
    @DisplayName(value="String body, should send a POST request with body")
    public void postStringBody() throws Exception {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/post-string")).post("text/plain", "A string body").build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)server.getLastRequest()).returns((Object)"POST", RecordedRequest::getMethod)).returns((Object)"A string body", rr -> rr.getBody().readUtf8())).extracting(rr -> rr.getHeader("Content-Type")).asString().startsWith((CharSequence)"text/plain");
    }

    @Test
    @DisplayName(value="InputStream body, should send a POST request with body")
    public void postInputStreamBody() throws Exception {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/post-input-stream")).post("text/plain", (InputStream)new ByteArrayInputStream("A string body".getBytes(StandardCharsets.UTF_8)), -1L).build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)server.getLastRequest()).returns((Object)"POST", RecordedRequest::getMethod)).returns((Object)"A string body", rr -> rr.getBody().readUtf8())).extracting(rr -> rr.getHeader("Content-Type")).asString().startsWith((CharSequence)"text/plain");
    }

    @Test
    @DisplayName(value="byte[] body, should send a POST request with body")
    public void postBytesBody() throws Exception {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/post-bytes")).post("text/plain", "A string body".getBytes(StandardCharsets.UTF_8)).build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)server.getLastRequest()).returns((Object)"POST", RecordedRequest::getMethod)).returns((Object)"A string body", rr -> rr.getBody().readUtf8())).extracting(rr -> rr.getHeader("Content-Type")).asString().startsWith((CharSequence)"text/plain");
    }

    @Test
    @DisplayName(value="FormData body, should send a POST request with body")
    public void postFormDataBody() throws Exception {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/post-bytes")).post(Collections.singletonMap("field", "value")).build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)server.getLastRequest()).returns((Object)"POST", RecordedRequest::getMethod)).returns((Object)"field=value", rr -> rr.getBody().readUtf8())).extracting(rr -> rr.getHeader("Content-Type")).asString().startsWith((CharSequence)"application/x-www-form-urlencoded");
    }
}

