/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketHandshakeException;
import io.fabric8.mockwebserver.DefaultMockServer;
import io.fabric8.mockwebserver.dsl.EventDoneable;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import io.fabric8.mockwebserver.dsl.WebSocketSessionBuilder;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractHttpClientNewWebSocketBuilderTest {
    private static DefaultMockServer server;
    private HttpClient httpClient;

    @BeforeAll
    static void beforeAll() {
        server = new DefaultMockServer(false);
        server.start();
    }

    @AfterAll
    static void afterAll() {
        server.shutdown();
    }

    @BeforeEach
    void setUp() {
        this.httpClient = this.getHttpClientFactory().newBuilder().build();
    }

    @AfterEach
    void tearDown() {
        this.httpClient.close();
    }

    protected abstract HttpClient.Factory getHttpClientFactory();

    @Test
    void buildAsyncConnectsAndUpgrades() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)server.expect().withPath("/websocket-test")).andUpgradeToWebSocket()).open(new Object[0])).done()).always();
        final AtomicBoolean open = new AtomicBoolean(false);
        this.httpClient.newWebSocketBuilder().uri(URI.create(server.url("/websocket-test"))).buildAsync(new WebSocket.Listener(){

            public void onOpen(WebSocket webSocket) {
                open.set(true);
            }
        }).get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((AtomicBoolean)open).isTrue();
    }

    @Test
    void buildAsyncCantUpgradeThrowsWebSocketHandshakeException() {
        CompletableFuture future = this.httpClient.newWebSocketBuilder().uri(URI.create(server.url("/not-found"))).buildAsync(new WebSocket.Listener(){});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            WebSocket cfr_ignored_0 = (WebSocket)future.get(10L, TimeUnit.SECONDS);
        }).isInstanceOf(ExecutionException.class)).hasCauseInstanceOf(WebSocketHandshakeException.class);
    }

    @Test
    void buildAsyncIncludesRequiredHeadersAndPropagatesConfigured() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)server.expect().withPath("/websocket-headers-test")).andUpgradeToWebSocket()).open(new Object[0])).done()).always();
        final AtomicBoolean open = new AtomicBoolean(false);
        this.httpClient.newWebSocketBuilder().header("A-Random-Header", "A-Random-Value").subprotocol("amqp").uri(URI.create(server.url("/websocket-headers-test"))).buildAsync(new WebSocket.Listener(){

            public void onOpen(WebSocket webSocket) {
                open.set(true);
            }
        }).get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((AtomicBoolean)open).isTrue();
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)server.getLastRequest().getHeaders().toMultimap()).containsEntry((Object)"a-random-header", Collections.singletonList("A-Random-Value"))).containsEntry((Object)"sec-websocket-protocol", Collections.singletonList("amqp"))).containsEntry((Object)"connection", Collections.singletonList("Upgrade"))).containsEntry((Object)"upgrade", Collections.singletonList("websocket"))).containsEntry((Object)"sec-websocket-version", Collections.singletonList("13"))).containsKey((Object)"sec-websocket-key");
    }
}

