/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpHeaders;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.utils.OpenIDConnectionUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;

public class TokenRefreshInterceptor
implements Interceptor {
    public static final String NAME = "TOKEN";
    private final Config config;
    private HttpClient.Factory factory;
    private static final int REFRESH_INTERVAL_MINUTE = 1;
    private Instant latestRefreshTimestamp;

    public TokenRefreshInterceptor(Config config, HttpClient.Factory factory, Instant latestRefreshTimestamp) {
        this.config = config;
        this.latestRefreshTimestamp = latestRefreshTimestamp;
        this.factory = factory;
    }

    @Override
    public Interceptor withConfig(Config config) {
        return new TokenRefreshInterceptor(config, this.factory, this.latestRefreshTimestamp);
    }

    @Override
    public void before(BasicBuilder headerBuilder, HttpHeaders headers) {
        if (this.isTimeToRefresh()) {
            this.refreshToken(headerBuilder);
        }
    }

    private boolean isTimeToRefresh() {
        return this.latestRefreshTimestamp.plus(1L, ChronoUnit.MINUTES).isBefore(Instant.now());
    }

    @Override
    public CompletableFuture<Boolean> afterFailure(BasicBuilder headerBuilder, HttpResponse<?> response) {
        if (response.code() == 401) {
            return this.refreshToken(headerBuilder);
        }
        return CompletableFuture.completedFuture(false);
    }

    private CompletableFuture<Boolean> refreshToken(BasicBuilder headerBuilder) {
        Config newestConfig = this.config.refresh();
        CompletableFuture<String> newAccessToken = this.extractNewAccessTokenFrom(newestConfig);
        return newAccessToken.thenApply(token -> this.overrideNewAccessTokenToConfig((String)token, headerBuilder, this.config));
    }

    private CompletableFuture<String> extractNewAccessTokenFrom(Config newestConfig) {
        if (newestConfig.getAuthProvider() != null && newestConfig.getAuthProvider().getName().equalsIgnoreCase("oidc")) {
            return OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig(newestConfig.getAuthProvider().getConfig(), this.factory.newBuilder());
        }
        return CompletableFuture.completedFuture(newestConfig.getOauthToken());
    }

    private boolean overrideNewAccessTokenToConfig(String newAccessToken, BasicBuilder headerBuilder, Config existConfig) {
        if (Utils.isNotNullOrEmpty(newAccessToken)) {
            headerBuilder.setHeader("Authorization", "Bearer " + newAccessToken);
            existConfig.setOauthToken(newAccessToken);
            this.updateLatestRefreshTimestamp();
            return true;
        }
        return false;
    }

    private void updateLatestRefreshTimestamp() {
        this.latestRefreshTimestamp = Instant.now();
    }
}

