/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.utils.BackwardsCompatibilityInterceptor;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.ImpersonatorInterceptor;
import io.fabric8.kubernetes.client.utils.TokenRefreshInterceptor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

class HttpClientUtilsTest {
    HttpClientUtilsTest() {
    }

    @Test
    void testCreateApplicableInterceptors() {
        Config config = new ConfigBuilder().build();
        Collection interceptorList = HttpClientUtils.createApplicableInterceptors((Config)config, null).values();
        ((AbstractCollectionAssert)((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat(interceptorList).isNotNull()).hasSize(3)).hasAtLeastOneElementOfType(ImpersonatorInterceptor.class)).hasAtLeastOneElementOfType(TokenRefreshInterceptor.class);
    }

    @Test
    void testCreateApplicableInterceptorsWithBackwardsCompatibilityDisabled() {
        Config config = new ConfigBuilder().build();
        System.setProperty("kubernetes.backwardsCompatibilityInterceptor.disable", "true");
        try {
            Collection interceptorList = HttpClientUtils.createApplicableInterceptors((Config)config, null).values();
            ((AbstractCollectionAssert)((AbstractCollectionAssert)((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat(interceptorList).isNotNull()).hasSize(3)).noneMatch(i -> i instanceof BackwardsCompatibilityInterceptor)).hasAtLeastOneElementOfType(ImpersonatorInterceptor.class)).hasAtLeastOneElementOfType(TokenRefreshInterceptor.class);
        }
        finally {
            System.clearProperty("kubernetes.backwardsCompatibilityInterceptor.disable");
        }
    }

    @Nested
    @DisplayName(value="getProxyUrl")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class GetProxyUrl {
        private ConfigBuilder configBuilder;

        GetProxyUrl() {
        }

        @BeforeEach
        void setUp() {
            this.configBuilder = new ConfigBuilder();
        }

        @DisplayName(value="With httpProxy and noProxy matching master url, should return null")
        @ParameterizedTest(name="{index}: Master URL ''{0}'' matched by No Proxy ''{1}'' ")
        @MethodSource(value={"masterUrlMatchesNoProxyInput"})
        void masterUrlMatchesNoProxy(String masterUrl, String[] noProxy) throws MalformedURLException {
            Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)this.configBuilder.withHttpProxy("http://proxy.url:8080")).withMasterUrl(masterUrl)).withNoProxy(noProxy)).build();
            URL url = HttpClientUtils.getProxyUrl((Config)config);
            Assertions.assertThat((URL)url).isNull();
        }

        Stream<Arguments> masterUrlMatchesNoProxyInput() {
            return Stream.of(Arguments.arguments((Object[])new Object[]{"http://192.168.1.100:6443", new String[]{"192.168.1.0/24"}}), Arguments.arguments((Object[])new Object[]{"master.example.com", new String[]{"master.example.com"}}), Arguments.arguments((Object[])new Object[]{"master.example.com", new String[]{".example.com"}}), Arguments.arguments((Object[])new Object[]{"master.example.com", new String[]{"circleci-internal-outer-build-agent", "one.com", "other.com", ".com"}}), Arguments.arguments((Object[])new Object[]{"192.168.1.110", new String[]{"192.168.1.110"}}), Arguments.arguments((Object[])new Object[]{"192.168.1.110", new String[]{"http://192.168.1.110"}}), Arguments.arguments((Object[])new Object[]{"192.168.1.110", new String[]{"https://192.168.1.110"}}), Arguments.arguments((Object[])new Object[]{"192.168.1.110", new String[]{"192.168.1.0/24"}}), Arguments.arguments((Object[])new Object[]{"192.168.1.110", new String[]{"http://192.168.1.0/24"}}));
        }

        @DisplayName(value="With httpProxy and noProxy not matching master url, should return proxy url")
        @ParameterizedTest(name="{index}: Master URL ''{0}'' not matched by No Proxy ''{1}'' ")
        @MethodSource(value={"masterUrlDoesNotMatchNoProxyInput"})
        void masterUrlDoesNotMatchNoProxy(String masterUrl, String[] noProxy) throws MalformedURLException {
            Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)this.configBuilder.withHttpProxy("http://proxy.url:8080")).withMasterUrl(masterUrl)).withNoProxy(noProxy)).build();
            URL url = HttpClientUtils.getProxyUrl((Config)config);
            Assertions.assertThat((URL)url).isEqualToWithSortedQueryParameters(new URL("http://proxy.url:8080"));
        }

        Stream<Arguments> masterUrlDoesNotMatchNoProxyInput() {
            return Stream.of(Arguments.arguments((Object[])new Object[]{"http://192.168.2.100:6443", new String[]{"192.168.1.0/24"}}), Arguments.arguments((Object[])new Object[]{"master.example.com", null}), Arguments.arguments((Object[])new Object[]{"master.example.com", new String[0]}), Arguments.arguments((Object[])new Object[]{"master.example.com", new String[]{"master1.example.com"}}), Arguments.arguments((Object[])new Object[]{"master.example.com", new String[]{".example1.com"}}), Arguments.arguments((Object[])new Object[]{"master.example.com", new String[]{"circleci-internal-outer-build-agent"}}), Arguments.arguments((Object[])new Object[]{"master.example.com", new String[]{"one.com", "other.com", "master.example.", ".co"}}), Arguments.arguments((Object[])new Object[]{"192.168.1.110", new String[]{"192.168.1.111"}}), Arguments.arguments((Object[])new Object[]{"192.168.1.110", new String[]{"http://192.168.1.111"}}), Arguments.arguments((Object[])new Object[]{"192.168.1.110", new String[]{"https://192.168.1.111"}}), Arguments.arguments((Object[])new Object[]{"192.168.1.110", new String[]{"192.168.10.0/24"}}), Arguments.arguments((Object[])new Object[]{"192.168.1.110", new String[]{"http://192.168.1.0/32"}}));
        }

        @DisplayName(value="With httpProxy and invalid noProxy should throw Exception")
        @ParameterizedTest(name="{index}: ''{0}'' is invalid")
        @ValueSource(strings={"*.my.domain.com", "!!!.com", "()-?\u00bf?", "http://proxy url"})
        void invalidNoProxyUrlThrowsException(String noProxy) {
            Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)this.configBuilder.withHttpProxy("http://proxy.url:8080")).withMasterUrl("master.url")).withNoProxy(new String[]{noProxy})).build();
            ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> HttpClientUtils.getProxyUrl((Config)config)).isInstanceOf(MalformedURLException.class)).hasMessage("NO_PROXY URL contains invalid entry: '" + noProxy + "'");
        }

        @Test
        void whenHttpsProxyUrlWithNoPort_shouldThrowException() {
            Config config = ((ConfigBuilder)((ConfigBuilder)this.configBuilder.withMasterUrl("http://localhost")).withHttpProxy("http://192.168.0.1")).build();
            Assertions.assertThatIllegalArgumentException().isThrownBy(() -> HttpClientUtils.getProxyUrl((Config)config)).withMessage("Failure in creating proxy URL. Proxy port is required!");
        }

        @Test
        void withNoHttpProxyProvidedReturnsNull() throws MalformedURLException {
            Config config = ((ConfigBuilder)((ConfigBuilder)this.configBuilder.withMasterUrl("master.url")).withNoProxy(new String[]{"other.url"})).build();
            URL url = HttpClientUtils.getProxyUrl((Config)config);
            Assertions.assertThat((URL)url).isNull();
        }
    }
}

