/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.TestHttpHeaders;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class TestHttpResponse<T>
extends TestHttpHeaders<TestHttpResponse<T>>
implements HttpResponse<T> {
    private int code;
    private T body;
    private HttpRequest request;
    private HttpResponse<T> previousResponse;

    public int code() {
        return this.code;
    }

    public T body() {
        return this.body;
    }

    public HttpRequest request() {
        return this.request;
    }

    public Optional<HttpResponse<?>> previousResponse() {
        return Optional.ofNullable(this.previousResponse);
    }

    public int getCode() {
        return this.code;
    }

    public TestHttpResponse<T> withCode(int code) {
        this.code = code;
        return this;
    }

    public T getBody() {
        return this.body;
    }

    public TestHttpResponse<T> withBody(T body) {
        this.body = body;
        return this;
    }

    public HttpResponse<T> withRequest(HttpRequest request) {
        this.request = request;
        return this;
    }

    public HttpResponse<T> getPreviousResponse() {
        return this.previousResponse;
    }

    public HttpResponse<T> withPreviousResponse(HttpResponse<T> previousResponse) {
        this.previousResponse = previousResponse;
        return this;
    }

    public static TestHttpResponse<byte[]> from(int code, String body) {
        return new TestHttpResponse().withCode(code).withBody(body.getBytes(StandardCharsets.UTF_8));
    }
}

