/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpHeaders;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.mockwebserver.DefaultMockServer;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public abstract class AbstractInterceptorTest {
    private static DefaultMockServer server;

    @BeforeAll
    static void beforeAll() {
        server = new DefaultMockServer(false);
        server.start();
    }

    @AfterAll
    static void afterAll() {
        server.shutdown();
    }

    protected abstract HttpClient.Factory getHttpClientFactory();

    @Test
    @DisplayName(value="before, should add a header to the HTTP request")
    public void beforeAddsHeaderToRequest() throws Exception {
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().addOrReplaceInterceptor("test", new Interceptor(){

            public void before(BasicBuilder builder, HttpHeaders headers) {
                builder.header("Test-Header", "Test-Value");
            }
        });
        try (HttpClient client = builder.build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/intercept-before")).build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        Assertions.assertThat((Map)server.getLastRequest().getHeaders().toMultimap()).containsEntry((Object)"test-header", Collections.singletonList("Test-Value"));
    }

    @Test
    @DisplayName(value="afterFailure (HTTP), replaces the HttpResponse produced by HttpClient.sendAsync")
    public void afterHttpFailureReplacesResponseInSendAsync() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/intercepted-url")).andReturn(200, (Object)"This works")).always();
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().addOrReplaceInterceptor("test", new Interceptor(){

            public CompletableFuture<Boolean> afterFailure(BasicBuilder builder, HttpResponse<?> response) {
                builder.uri(URI.create(server.url("/intercepted-url")));
                return CompletableFuture.completedFuture(true);
            }
        });
        try (HttpClient client = builder.build();){
            HttpResponse result = (HttpResponse)client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/not-found")).build(), String.class).get(10L, TimeUnit.SECONDS);
            ((ObjectAssert)Assertions.assertThat((Object)result).returns((Object)"This works", HttpResponse::body)).returns((Object)200, HttpResponse::code);
        }
    }

    @Test
    @DisplayName(value="afterFailure (HTTP), replaces the HttpResponse produced by HttpClient.consumeLines")
    public void afterHttpFailureReplacesResponseInConsumeLines() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/intercepted-url")).andReturn(200, (Object)"This works")).always();
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().addOrReplaceInterceptor("test", new Interceptor(){

            public CompletableFuture<Boolean> afterFailure(BasicBuilder builder, HttpResponse<?> response) {
                builder.uri(URI.create(server.url("/intercepted-url")));
                return CompletableFuture.completedFuture(true);
            }
        });
        CompletableFuture result = new CompletableFuture();
        try (HttpClient client = builder.build();){
            HttpResponse asyncR = (HttpResponse)client.consumeLines(client.newHttpRequestBuilder().uri(server.url("/not-found")).build(), (s, ab) -> {
                result.complete(s);
                ab.consume();
            }).get(10L, TimeUnit.SECONDS);
            ((HttpClient.AsyncBody)asyncR.body()).consume();
            ((HttpClient.AsyncBody)asyncR.body()).done().get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)result.get())).isEqualTo("This works");
        }
    }

    @Test
    @DisplayName(value="afterFailure (HTTP), replaces the HttpResponse produced by HttpClient.consumeBytes")
    public void afterHttpFailureReplacesResponseInConsumeBytes() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/intercepted-url")).andReturn(200, (Object)"This works")).always();
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().addOrReplaceInterceptor("test", new Interceptor(){

            public CompletableFuture<Boolean> afterFailure(BasicBuilder builder, HttpResponse<?> response) {
                builder.uri(URI.create(server.url("/intercepted-url")));
                return CompletableFuture.completedFuture(true);
            }
        });
        CompletableFuture result = new CompletableFuture();
        try (HttpClient client = builder.build();){
            HttpResponse asyncR = (HttpResponse)client.consumeBytes(client.newHttpRequestBuilder().uri(server.url("/not-found")).build(), (s, ab) -> {
                result.complete(StandardCharsets.UTF_8.decode((ByteBuffer)s.iterator().next()).toString());
                ab.consume();
            }).get(10L, TimeUnit.SECONDS);
            ((HttpClient.AsyncBody)asyncR.body()).consume();
            ((HttpClient.AsyncBody)asyncR.body()).done().get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)result.get())).isEqualTo("This works");
        }
    }

    @Test
    @DisplayName(value="interceptors should be applied in the order they were added")
    public void interceptorsAreAppliedInOrder() throws Exception {
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().addOrReplaceInterceptor("first", new Interceptor(){

            public void before(BasicBuilder builder, HttpHeaders headers) {
                builder.header("Test-Header", "Test-Value");
            }
        }).addOrReplaceInterceptor("second", new Interceptor(){

            public void before(BasicBuilder builder, HttpHeaders headers) {
                builder.setHeader("Test-Header", "Test-Value-Override");
            }
        });
        try (HttpClient client = builder.build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/intercept-before")).build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        Assertions.assertThat((Map)server.getLastRequest().getHeaders().toMultimap()).containsEntry((Object)"test-header", Collections.singletonList("Test-Value-Override"));
    }

    @Test
    @DisplayName(value="afterFailure sees the overriden RequestConfig")
    public void afterHttpFailureSuppliedConfig() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/intercepted-url")).andReturn(200, (Object)"This works")).once();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/other-url")).andReturn(200, (Object)"Overriden")).once();
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().addOrReplaceInterceptor("test", (Interceptor)new ConfigAwareInterceptor());
        try (HttpClient client = builder.build();){
            Config config = Config.empty();
            config.setImpersonateUsername("other-url");
            HttpClient derivedClient = client.newBuilder().requestConfig(config).build();
            HttpResponse result = (HttpResponse)derivedClient.sendAsync(derivedClient.newHttpRequestBuilder().uri(server.url("/not-found")).build(), String.class).get(10L, TimeUnit.SECONDS);
            ((ObjectAssert)Assertions.assertThat((Object)result).returns((Object)"Overriden", HttpResponse::body)).returns((Object)200, HttpResponse::code);
        }
    }

    private static final class ConfigAwareInterceptor
    implements Interceptor {
        private Config config;

        private ConfigAwareInterceptor() {
        }

        public CompletableFuture<Boolean> afterFailure(BasicBuilder builder, HttpResponse<?> response) {
            String endpoint = "intercepted-url";
            if (this.config != null && this.config.getImpersonateUsername() != null) {
                endpoint = this.config.getImpersonateUsername();
            }
            builder.uri(URI.create(server.url("/" + endpoint)));
            return CompletableFuture.completedFuture(true);
        }

        public Interceptor withConfig(Config config) {
            ConfigAwareInterceptor result = new ConfigAwareInterceptor();
            result.config = config;
            return result;
        }
    }
}

