/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.utils.URLUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

class URLUtilsTest {
    URLUtilsTest() {
    }

    @Test
    void shouldJoinUrlWithoutQueryParams() {
        String masterUrl = "https://oso-master-url:8888/kubernetes";
        String fullUrl = URLUtils.join((String[])new String[]{masterUrl, "api"});
        MatcherAssert.assertThat((Object)fullUrl, (Matcher)CoreMatchers.is((Object)"https://oso-master-url:8888/kubernetes/api"));
    }

    @Test
    void shouldAppendUrlWithQueryParams() {
        String masterUrl = "https://oso-master-url:8888/kubernetes?param1=value";
        String fullUrl = URLUtils.join((String[])new String[]{masterUrl, "port?port=port"});
        MatcherAssert.assertThat((Object)fullUrl, (Matcher)CoreMatchers.is((Object)"https://oso-master-url:8888/kubernetes/port?port=port&param1=value"));
    }

    @Test
    void shouldAppendUrlWithMultipleQueryParams() {
        String masterUrl = "https://oso-master-url:8888/kubernetes?param1=value";
        String fullUrl = URLUtils.join((String[])new String[]{masterUrl, "port?port=port", "host=host"});
        MatcherAssert.assertThat((Object)fullUrl, (Matcher)CoreMatchers.is((Object)"https://oso-master-url:8888/kubernetes/port?port=port&host=host&param1=value"));
    }

    @Test
    void shouldJoinUrlWithQueryParams() {
        String masterUrl = "https://oso-master-url:8888/kubernetes?key=value";
        String fullUrl = URLUtils.join((String[])new String[]{masterUrl, "api"});
        MatcherAssert.assertThat((Object)fullUrl, (Matcher)CoreMatchers.is((Object)"https://oso-master-url:8888/kubernetes/api?key=value"));
    }

    @Test
    void shouldJoinNoneUrl() {
        String masterUrl = "images.openshift.io";
        String fullUrl = URLUtils.join((String[])new String[]{masterUrl, "api"});
        MatcherAssert.assertThat((Object)fullUrl, (Matcher)CoreMatchers.is((Object)"images.openshift.io/api"));
    }
}

