/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.HttpClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class KubernetesClientBuilderTest {
    KubernetesClientBuilderTest() {
    }

    @Test
    void testHttpClientConfiguration() {
        KubernetesClientBuilder builder = new KubernetesClientBuilder(null);
        HttpClient.Factory mockFactory = (HttpClient.Factory)Mockito.mock(HttpClient.Factory.class);
        HttpClient.Builder mockBuilder = (HttpClient.Builder)Mockito.mock(HttpClient.Builder.class);
        Mockito.when((Object)mockFactory.newBuilder((Config)Mockito.any())).thenReturn((Object)mockBuilder);
        builder.withHttpClientFactory(mockFactory).withHttpClientBuilderConsumer(b -> b.proxyAuthorization("something"));
        builder.getHttpClient();
        ((HttpClient.Builder)Mockito.verify((Object)mockBuilder)).proxyAuthorization("something");
    }

    @Test
    void testConfigNested() {
        KubernetesClientBuilder builder = new KubernetesClientBuilder(null);
        builder.withConfig(((ConfigBuilder)new ConfigBuilder().withWatchReconnectLimit(600)).build());
        ((KubernetesClientBuilder.ConfigNested)builder.editOrNewConfig().withApiVersion("x.y")).endConfig();
        KubernetesClientBuilder.ConfigNested configNested = builder.editOrNewConfig();
        Assertions.assertEquals((Object)"x.y", (Object)configNested.getApiVersion());
        Assertions.assertEquals((int)600, (int)configNested.getWatchReconnectLimit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testNullContextClassLoader() {
        ClassLoader currContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(null);
            Exception e = (Exception)Assertions.assertThrows(KubernetesClientException.class, KubernetesClientBuilder::new);
            Throwable t = e.getCause();
            Assertions.assertEquals(ClassNotFoundException.class, t.getClass());
            Assertions.assertEquals((Object)"io.fabric8.kubernetes.client.impl.KubernetesClientImpl", (Object)t.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(currContextClassLoader);
        }
    }
}

