/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.AuthProviderConfigBuilder;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.internal.KubeConfigUtils;
import io.fabric8.kubernetes.client.internal.SSLUtils;
import io.fabric8.kubernetes.client.utils.IOHelpers;
import io.fabric8.kubernetes.client.utils.OpenIDConnectionUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class OpenIDConnectionUtilsTest {
    HttpClient mockClient = (HttpClient)Mockito.mock(HttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);

    OpenIDConnectionUtilsTest() {
    }

    @Test
    void testLoadTokenURL() throws Exception {
        String openIdIssuer = "https://accounts.example.com";
        String tokenEndpointResponse = "{\"issuer\": \"https://accounts.example.com\", \"token_endpoint\": \"https://oauth2.exampleapis.com/token\"}";
        this.mockHttpClient(200, tokenEndpointResponse);
        Map discoveryDocumentMap = (Map)OpenIDConnectionUtils.getOIDCDiscoveryDocumentAsMap((HttpClient)this.mockClient, (String)openIdIssuer).get();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)discoveryDocumentMap);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"https://oauth2.exampleapis.com/token", discoveryDocumentMap.get("token_endpoint"));
    }

    @Test
    void testLoadTokenURLWhenNotFound() throws Exception {
        String openIdIssuer = "https://accounts.example.com";
        String tokenEndpointResponse = "{}";
        this.mockHttpClient(404, tokenEndpointResponse);
        Map discoveryDocumentAsMap = (Map)OpenIDConnectionUtils.getOIDCDiscoveryDocumentAsMap((HttpClient)this.mockClient, (String)openIdIssuer).get();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)discoveryDocumentAsMap.isEmpty());
    }

    @Test
    void testGetWellKnownUrlForOpenIDIssuer() {
        String openIdIssuer = "https://accounts.example.com";
        String wellKnownUrl = OpenIDConnectionUtils.getWellKnownUrlForOpenIDIssuer((String)openIdIssuer);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"https://accounts.example.com/.well-known/openid-configuration", (Object)wellKnownUrl);
    }

    @Test
    void testRefreshOidcToken() throws Exception {
        String clientId = "test-client-id";
        String refreshToken = "test-refresh-token";
        String clientSecret = "test-client-secret";
        String tokenEndpointUrl = "https://oauth2.exampleapis.com/token";
        this.mockHttpClient(200, "{\"id_token\":\"thisisatesttoken\",\"access_token\": \"thisisrefreshtoken\",\"expires_in\": 3599,\"scope\": \"openid https://www.exampleapis.com/auth/userinfo.email\",\"token_type\": \"Bearer\"}");
        Map response = (Map)OpenIDConnectionUtils.refreshOidcToken((HttpClient)this.mockClient, (String)clientId, (String)refreshToken, (String)clientSecret, (String)tokenEndpointUrl).get();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)response);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"thisisatesttoken", response.get("id_token"));
    }

    @Test
    void testFetchOIDCProviderDiscoveryDocumentAndRefreshToken() throws Exception {
        HashMap<String, String> discoveryDocument = new HashMap<String, String>();
        discoveryDocument.put("token_endpoint", "https://oauth2.exampleapis.com/token");
        String clientId = "test-client-id";
        String refreshToken = "test-refresh-token";
        String clientSecret = "test-client-secret";
        this.mockHttpClient(200, "{\"id_token\":\"thisisatesttoken\",\"access_token\": \"thisisrefreshtoken\",\"expires_in\": 3599,\"scope\": \"openid https://www.exampleapis.com/auth/userinfo.email\",\"token_type\": \"Bearer\"}");
        String newAccessToken = String.valueOf(((Map)OpenIDConnectionUtils.refreshOidcToken((HttpClient)this.mockClient, (String)clientId, (String)refreshToken, (String)clientSecret, (String)OpenIDConnectionUtils.getParametersFromDiscoveryResponse(discoveryDocument, (String)"token_endpoint")).get()).get("id_token"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)newAccessToken);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"thisisatesttoken", (Object)newAccessToken);
    }

    @Test
    void testPersistKubeConfigWithUpdatedToken() throws IOException {
        HashMap<String, String> openIdProviderResponse = new HashMap<String, String>();
        openIdProviderResponse.put("id_token", "id-token-updated");
        openIdProviderResponse.put("refresh_token", "refresh-token-updated");
        File tempFile = Files.createTempFile("test", "kubeconfig", new FileAttribute[0]).toFile();
        Files.copy(this.getClass().getResourceAsStream("/test-kubeconfig-oidc"), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        Config theConfig = Config.fromKubeconfig(null, (String)IOHelpers.readFully((InputStream)new FileInputStream(tempFile), (Charset)StandardCharsets.UTF_8), (String)tempFile.getAbsolutePath());
        boolean isPersisted = OpenIDConnectionUtils.persistKubeConfigWithUpdatedToken((Config)theConfig, openIdProviderResponse);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)isPersisted);
        io.fabric8.kubernetes.api.model.Config config = KubeConfigUtils.parseConfig((File)tempFile);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)config);
        NamedContext currentNamedContext = KubeConfigUtils.getCurrentContext((io.fabric8.kubernetes.api.model.Config)config);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)currentNamedContext);
        int currentUserIndex = KubeConfigUtils.getNamedUserIndexFromConfig((io.fabric8.kubernetes.api.model.Config)config, (String)currentNamedContext.getContext().getUser());
        org.junit.jupiter.api.Assertions.assertTrue((currentUserIndex > 0 ? 1 : 0) != 0);
        Map authProviderConfig = ((NamedAuthInfo)config.getUsers().get(currentUserIndex)).getUser().getAuthProvider().getConfig();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)authProviderConfig.isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"id-token-updated", authProviderConfig.get("id-token"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"refresh-token-updated", authProviderConfig.get("refresh-token"));
    }

    @Test
    void testResolveOIDCTokenFromAuthConfigShouldReturnOldTokenWhenRefreshNotSupported() throws Exception {
        HashMap<String, String> currentAuthProviderConfig = new HashMap<String, String>();
        currentAuthProviderConfig.put("client-id", "client-id");
        currentAuthProviderConfig.put("client-secret", "client-secret");
        currentAuthProviderConfig.put("id-token", "id-token");
        String token = (String)OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig((Config)Config.empty(), currentAuthProviderConfig, null).get();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"id-token", (Object)token);
    }

    @Test
    void resolveOIDCTokenFromAuthConfig_whenIDPCertNotPresentInAuthConfig_thenUseCertFromConfig() throws Exception {
        try (MockedStatic sslUtilsMockedStatic = Mockito.mockStatic(SSLUtils.class);){
            HashMap<String, String> currentAuthProviderConfig = new HashMap<String, String>();
            currentAuthProviderConfig.put("client-id", "client-id");
            currentAuthProviderConfig.put("client-secret", "client-secret");
            currentAuthProviderConfig.put("id-token", "id-token");
            currentAuthProviderConfig.put("refresh-token", "refresh-token");
            currentAuthProviderConfig.put("idp-issuer-url", "https://iam.cloud.example.com/identity");
            Config config = ((ConfigBuilder)new ConfigBuilder(Config.empty()).withCaCertData("cert")).build();
            HttpClient.Builder builder = (HttpClient.Builder)Mockito.mock(HttpClient.Builder.class);
            HttpClient httpClient = (HttpClient)Mockito.mock(HttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            Mockito.when((Object)builder.build()).thenReturn((Object)httpClient);
            OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig((Config)config, currentAuthProviderConfig, (HttpClient.Builder)builder).get();
            String decodedCert = new String(Base64.getDecoder().decode("cert"));
            sslUtilsMockedStatic.verify(() -> SSLUtils.trustManagers((String)((String)ArgumentMatchers.eq((Object)decodedCert)), (String)((String)ArgumentMatchers.isNull()), (boolean)ArgumentMatchers.anyBoolean(), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull())));
            sslUtilsMockedStatic.verify(() -> SSLUtils.keyManagers((String)((String)ArgumentMatchers.eq((Object)decodedCert)), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull())));
        }
    }

    @Test
    void resolveOIDCTokenFromAuthConfig_whenIDPCertNotPresentInAuthConfig_thenUseCertFileFromConfig(@TempDir File temporaryFolder) throws Exception {
        try (MockedStatic sslUtilsMockedStatic = Mockito.mockStatic(SSLUtils.class);){
            File caCertFile = new File(temporaryFolder, "ca.crt");
            Files.write(caCertFile.toPath(), "cert".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            HashMap<String, String> currentAuthProviderConfig = new HashMap<String, String>();
            currentAuthProviderConfig.put("client-id", "client-id");
            currentAuthProviderConfig.put("client-secret", "client-secret");
            currentAuthProviderConfig.put("id-token", "id-token");
            currentAuthProviderConfig.put("refresh-token", "refresh-token");
            currentAuthProviderConfig.put("idp-issuer-url", "https://iam.cloud.example.com/identity");
            Config config = ((ConfigBuilder)new ConfigBuilder(Config.empty()).withCaCertFile(caCertFile.getAbsolutePath())).build();
            HttpClient.Builder builder = (HttpClient.Builder)Mockito.mock(HttpClient.Builder.class);
            HttpClient httpClient = (HttpClient)Mockito.mock(HttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            Mockito.when((Object)builder.build()).thenReturn((Object)httpClient);
            OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig((Config)config, currentAuthProviderConfig, (HttpClient.Builder)builder).get();
            sslUtilsMockedStatic.verify(() -> SSLUtils.trustManagers((String)((String)ArgumentMatchers.eq((Object)"cert")), (String)((String)ArgumentMatchers.isNull()), (boolean)ArgumentMatchers.anyBoolean(), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull())));
            sslUtilsMockedStatic.verify(() -> SSLUtils.keyManagers((String)((String)ArgumentMatchers.eq((Object)"cert")), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull())));
        }
    }

    @Test
    void testgetParametersFromDiscoveryResponse() {
        HashMap<String, String> discoveryDocument = new HashMap<String, String>();
        discoveryDocument.put("issuer", "https://api.login.example.com");
        discoveryDocument.put("token_endpoint", "https//api.login.example.com/oauth2/get_token");
        discoveryDocument.put("jwks_uri", "https//api.login.example.com/openid/v1/certs");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"https//api.login.example.com/oauth2/get_token", (Object)OpenIDConnectionUtils.getParametersFromDiscoveryResponse(discoveryDocument, (String)"token_endpoint"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)OpenIDConnectionUtils.getParametersFromDiscoveryResponse(discoveryDocument, (String)"userinfo_endpoint"));
    }

    @Test
    void idTokenExpired_whenEmptyFormatProvided_thenReturnTrue() {
        Assertions.assertThat((boolean)OpenIDConnectionUtils.idTokenExpired((Config)this.createNewConfigWithAuthProviderIdToken(""))).isTrue();
    }

    @Test
    void idTokenExpired_whenInvalidJwtTokenFormatProvided_thenReturnTrue() {
        Assertions.assertThat((boolean)OpenIDConnectionUtils.idTokenExpired((Config)this.createNewConfigWithAuthProviderIdToken("invalid-jwt-token"))).isTrue();
    }

    @Test
    void idTokenExpired_whenInvalidJwtPayloadProvided_thenReturnTrue() {
        Assertions.assertThat((boolean)OpenIDConnectionUtils.idTokenExpired((Config)this.createNewConfigWithAuthProviderIdToken("header.payload.signature"))).isTrue();
    }

    @Test
    void idTokenExpired_whenOldTokenProvided_thenReturnTrue() {
        String token = "eyJhbGciOiJSUzI1NiJ9.eyJpc3MiOiJodHRwczovL21sYi50cmVtb2xvLmxhbjo4MDQzL2F1dGgvaWRwL29pZGMiLCJhdWQiOiJrdWJlcm5ldGVzIiwiZXhwIjoxNDc0NTk2NjY5LCJqdGkiOiI2RDUzNXoxUEpFNjJOR3QxaWVyYm9RIiwiaWF0IjoxNDc0NTk2MzY5LCJuYmYiOjE0NzQ1OTYyNDksInN1YiI6Im13aW5kdSIsInVzZXJfcm9sZSI6WyJ1c2VycyIsIm5ldy1uYW1lc3BhY2Utdmlld2VyIl0sImVtYWlsIjoibXdpbmR1QG5vbW9yZWplZGkuY29tIn0.f2As579n9VNoaKzoF-dOQGmXkFKf1FMyNV0-va_B63jn-_n9LGSCca_6IVMP8pO-Zb4KvRqGyTP0r3HkHxYy5c81AnIh8ijarruczl-TK_yF5akjSTHFZD-0gRzlevBDiH8Q79NAr-ky0P4iIXS8lY9Vnjch5MF74Zx0c3alKJHJUnnpjIACByfF2SCaYzbWFMUNat-K1PaUk5-ujMBG7yYnr95xD-63n8CO8teGUAAEMx6zRjzfhnhbzX-ajwZLGwGUBT4WqjMs70-6a7_8gZmLZb2az1cZynkFRj2BaCkVT3A2RrjeEwZEtGXlMqKJ1_I2ulrOVsYx01_yD35-rw";
        Assertions.assertThat((boolean)OpenIDConnectionUtils.idTokenExpired((Config)this.createNewConfigWithAuthProviderIdToken(token))).isTrue();
    }

    @Test
    void idTokenExpired_whenTokenStillNotExpired_thenReturnFalse() {
        Instant tokenExp = Instant.now().plusSeconds(30L);
        String payload = "{\"exp\": " + tokenExp.getEpochSecond() + "}";
        String token = "header." + Base64.getEncoder().encodeToString(payload.getBytes()) + ".signature";
        Assertions.assertThat((boolean)OpenIDConnectionUtils.idTokenExpired((Config)this.createNewConfigWithAuthProviderIdToken(token))).isFalse();
    }

    private void mockHttpClient(int responseCode, String responseAsStr) throws IOException {
        HttpResponse<String> mockSuccessResponse = this.mockResponse(responseCode, responseAsStr);
        Mockito.when((Object)this.mockClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(String.class))).thenReturn(CompletableFuture.completedFuture(mockSuccessResponse));
    }

    private HttpResponse<String> mockResponse(int responseCode, String responseBody) {
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class, (Answer)Mockito.CALLS_REAL_METHODS);
        Mockito.when((Object)response.code()).thenReturn((Object)responseCode);
        Mockito.when((Object)response.body()).thenReturn((Object)responseBody);
        return response;
    }

    private Config createNewConfigWithAuthProviderIdToken(String idToken) {
        return ((ConfigBuilder)new ConfigBuilder(Config.empty()).withAuthProvider(((AuthProviderConfigBuilder)new AuthProviderConfigBuilder().addToConfig("id-token", idToken)).build())).build();
    }
}

