/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.DefaultKubernetesResourceList;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventBuilder;
import io.fabric8.kubernetes.api.model.EventFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.batch.v1beta1.CronJob;
import io.fabric8.kubernetes.api.model.batch.v1beta1.CronJobList;
import io.fabric8.kubernetes.client.Good;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.MapAssert;
import org.assertj.core.data.MapEntry;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class KubernetesResourceUtilTest {
    private ConfigMap configMap1;

    KubernetesResourceUtilTest() {
    }

    @Test
    void testNullContextClassLoader() {
        ClassLoader currContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(null);
            org.junit.jupiter.api.Assertions.assertEquals(PodList.class, (Object)KubernetesResourceUtil.inferListType(Pod.class));
        }
        finally {
            Thread.currentThread().setContextClassLoader(currContextClassLoader);
        }
    }

    @BeforeEach
    public void createTestResource() {
        this.configMap1 = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("configmap1")).withNamespace("ns1")).withAnnotations(Collections.singletonMap("foo", "bar"))).withLabels(Collections.singletonMap("foo-label", "bar-label"))).endMetadata()).addToData("one", "1")).build();
    }

    @Test
    void testNullSafeOperationsForName() {
        String resourceName = KubernetesResourceUtil.getName((HasMetadata)this.configMap1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)resourceName);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"configmap1", (Object)resourceName);
    }

    @Test
    void testNullSafeOperationsForNamespace() {
        String namespace = KubernetesResourceUtil.getNamespace((HasMetadata)this.configMap1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)namespace);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ns1", (Object)namespace);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ns1/configmap1", (Object)KubernetesResourceUtil.getQualifiedName((HasMetadata)this.configMap1));
    }

    @Test
    void testNullSafeOperationsForLabels() {
        Map labels = KubernetesResourceUtil.getOrCreateLabels((HasMetadata)this.configMap1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)labels);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonMap("foo-label", "bar-label"), (Object)labels);
    }

    @Test
    void testNullSafeOperationsForAnnotations() {
        Map annos = KubernetesResourceUtil.getOrCreateAnnotations((HasMetadata)this.configMap1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)annos);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonMap("foo", "bar"), (Object)annos);
    }

    @Test
    void testNames() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)KubernetesResourceUtil.isValidName((String)KubernetesResourceUtil.getName((HasMetadata)this.configMap1)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)KubernetesResourceUtil.isValidName((String)"test.invalid.name"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)KubernetesResourceUtil.areLabelsValid((Map)KubernetesResourceUtil.getOrCreateAnnotations((HasMetadata)this.configMap1)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)KubernetesResourceUtil.areLabelsValid(Collections.singletonMap("NoUppercaseOrSpecialCharsLike=Equals", "bar")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)KubernetesResourceUtil.isValidName((String)KubernetesResourceUtil.sanitizeName((String)"test.invalid.name")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)KubernetesResourceUtil.isValidName((String)KubernetesResourceUtil.sanitizeName((String)"90notcool-n@me")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)KubernetesResourceUtil.isValidName((String)KubernetesResourceUtil.sanitizeName((String)"90notcool-n@me_______waytoooooooooolooooooooongand should be shorten for sure")));
    }

    @Test
    void testSubdomainValidation() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)KubernetesResourceUtil.isValidSubdomainName((String)"a.b"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)KubernetesResourceUtil.isValidSubdomainName((String)"a..b"));
    }

    @Test
    void testKeyValidation() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)KubernetesResourceUtil.isValidKey((String)"domain.prefix.io/label.key"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)KubernetesResourceUtil.isValidKey((String)"domain.prefix.io?label.key"));
    }

    @Test
    void testAnnotationValidation() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)KubernetesResourceUtil.areAnnotationsValid(Collections.singletonMap("simple-key", "Something not valid for a label!")));
    }

    @Test
    void testSortEventListBasedOnTimestamp() {
        ArrayList<Event> eventList = new ArrayList<Event>();
        eventList.add(((EventBuilder)((EventBuilder)((EventFluent.MetadataNested)new EventBuilder().withNewMetadata().withName("event2")).endMetadata()).withLastTimestamp("2020-06-12T06:45:16Z")).build());
        eventList.add(((EventBuilder)((EventBuilder)((EventFluent.MetadataNested)new EventBuilder().withNewMetadata().withName("event1")).endMetadata()).withLastTimestamp("2020-06-10T06:45:16Z")).build());
        eventList.add(((EventBuilder)((EventBuilder)((EventFluent.MetadataNested)new EventBuilder().withNewMetadata().withName("event3")).endMetadata()).withLastTimestamp("2020-06-13T06:45:16Z")).build());
        eventList.add(((EventBuilder)((EventFluent.MetadataNested)new EventBuilder().withNewMetadata().withName("eventWithoutLastTimestamp")).endMetadata()).build());
        KubernetesResourceUtil.sortEventListBasedOnTimestamp(eventList);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"eventWithoutLastTimestamp", (Object)((Event)eventList.get(0)).getMetadata().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"event3", (Object)((Event)eventList.get(1)).getMetadata().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"event2", (Object)((Event)eventList.get(2)).getMetadata().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"event1", (Object)((Event)eventList.get(3)).getMetadata().getName());
    }

    @Test
    @DisplayName(value="Should be able to get resource version")
    void testGetResourceVersion() {
        Pod pod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test")).withResourceVersion("1001")).endMetadata()).build();
        String resourceVersion = KubernetesResourceUtil.getResourceVersion((HasMetadata)pod);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1001", (Object)resourceVersion);
    }

    @Test
    @DisplayName(value="Should be able to update resource version")
    void testSetResourceVersion() {
        Pod pod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test")).withResourceVersion("1001")).endMetadata()).build();
        KubernetesResourceUtil.setResourceVersion((HasMetadata)pod, (String)"1002");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1002", (Object)pod.getMetadata().getResourceVersion());
    }

    @Test
    void testIsResourceReadyReturnsTrue() {
        Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.StatusNested)((DeploymentFluent.StatusNested)((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName("test")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(1))).withAvailableReplicas(Integer.valueOf(1))).endStatus()).build();
        boolean result = KubernetesResourceUtil.isResourceReady((HasMetadata)deployment);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result);
    }

    @Test
    void testIsResourceReadyReturnsFalse() {
        Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.StatusNested)((DeploymentFluent.StatusNested)((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName("test")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(2))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(1))).withAvailableReplicas(Integer.valueOf(1))).endStatus()).build();
        boolean result = KubernetesResourceUtil.isResourceReady((HasMetadata)deployment);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result);
    }

    @Test
    void testGetAge() {
        Pod pod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test")).withCreationTimestamp("2020-11-03T13:22:22Z")).endMetadata()).build();
        Duration duration = KubernetesResourceUtil.getAge((HasMetadata)pod);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)duration.isNegative());
    }

    @Test
    void testInferListType() {
        org.junit.jupiter.api.Assertions.assertEquals(PodList.class, (Object)KubernetesResourceUtil.inferListType(Pod.class));
        org.junit.jupiter.api.Assertions.assertEquals(ConfigMapList.class, (Object)KubernetesResourceUtil.inferListType(ConfigMap.class));
        org.junit.jupiter.api.Assertions.assertEquals(CronJobList.class, (Object)KubernetesResourceUtil.inferListType(CronJob.class));
        org.junit.jupiter.api.Assertions.assertEquals(DefaultKubernetesResourceList.class, (Object)KubernetesResourceUtil.inferListType(Good.class));
    }

    @Test
    void testCreateDefaultDockerRegistrySecret() throws JsonProcessingException {
        Secret secret = KubernetesResourceUtil.createDockerRegistrySecret((String)"http://harbor.inner.com", (String)"SecretAdmin", (String)"TestingSecret");
        String header = new String(Base64.getDecoder().decode((String)secret.getData().get(".dockerconfigjson")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"auths\":{\"http://harbor.inner.com\":{\"password\":\"TestingSecret\",\"auth\":\"U2VjcmV0QWRtaW46VGVzdGluZ1NlY3JldA==\",\"username\":\"SecretAdmin\"}}}", (Object)header);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"container-image-registry-secret", (Object)secret.getMetadata().getName());
    }

    @Test
    void testCreateDockerRegistrySecret() throws JsonProcessingException {
        Secret secret = KubernetesResourceUtil.createDockerRegistrySecret((String)"http://harbor.inner.com", (String)"SecretAdmin", (String)"TestingSecret", (String)"TestSecretName");
        String header = new String(Base64.getDecoder().decode((String)secret.getData().get(".dockerconfigjson")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"auths\":{\"http://harbor.inner.com\":{\"password\":\"TestingSecret\",\"auth\":\"U2VjcmV0QWRtaW46VGVzdGluZ1NlY3JldA==\",\"username\":\"SecretAdmin\"}}}", (Object)header);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"TestSecretName", (Object)secret.getMetadata().getName());
    }

    @Test
    void createNewConfigMapFromDirOrFiles_whenInvalidFileProvided_shouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> KubernetesResourceUtil.addEntriesFromDirOrFileToConfigMap((ConfigMapBuilder)new ConfigMapBuilder(), (String)"test-configmap", (Path)Paths.get("does-not-exist", new String[0]))).withMessage("invalid file path provided does-not-exist");
    }

    @Test
    void createNewConfigMapFromDirOrFiles_whenFileProvided_shouldCreateConfigMapFromFile() throws IOException {
        Path path = new File(this.getClass().getResource("/configmap-from-file/game-config/game.properties").getFile()).toPath();
        ConfigMap configMap = KubernetesResourceUtil.createConfigMapFromDirOrFiles((String)"test-configmap", (Path[])new Path[]{path});
        this.assertConfigMapContainsData(configMap, this.createExpectedEntry("game.properties", path));
    }

    @Test
    void createNewConfigMapFromDirOrFiles_whenDirProvided_shouldCreateConfigMapFromDir() throws IOException {
        Path filePath = new File(this.getClass().getResource("/configmap-from-file/game-config").getFile()).toPath();
        ConfigMap configMap = KubernetesResourceUtil.addEntriesFromDirOrFileToConfigMap((ConfigMapBuilder)new ConfigMapBuilder(), (String)"test-configmap", (Path)filePath).build();
        this.assertConfigMapContainsData(configMap, this.createExpectedEntry("game.properties", filePath.resolve("game.properties")), this.createExpectedEntry("ui.properties", filePath.resolve("ui.properties")));
    }

    @Test
    void createNewConfigMapFromDirOrFiles_whenMultipleDirsProvided_shouldCreateConfigMapFromDirs() throws IOException {
        Path dir1Path = new File(this.getClass().getResource("/configmap-from-file/game-config").getFile()).toPath();
        Path dir2Path = new File(this.getClass().getResource("/configmap-from-file/test-config").getFile()).toPath();
        ConfigMap configMap = KubernetesResourceUtil.createConfigMapFromDirOrFiles((String)"test-configmap", (Path[])new Path[]{dir1Path, dir2Path});
        this.assertConfigMapContainsData(configMap, this.createExpectedEntry("game.properties", dir1Path.resolve("game.properties")), this.createExpectedEntry("ui.properties", dir1Path.resolve("ui.properties")), this.createExpectedEntry("test.properties", dir2Path.resolve("test.properties")));
    }

    @Test
    void createNewConfigMapFromDirOrFiles_whenBinaryFileProvided_shouldCreateConfigMapFromFile() throws IOException {
        Path path = new File(this.getClass().getResource("/test.bin").getFile()).toPath();
        ConfigMap configMap = KubernetesResourceUtil.createConfigMapFromDirOrFiles((String)"test-configmap", (Path[])new Path[]{path});
        ((MapAssert)Assertions.assertThat((Object)configMap).extracting(ConfigMap::getBinaryData).asInstanceOf(InstanceOfAssertFactories.MAP)).contains(new Map.Entry[]{Assertions.entry((Object)"test.bin", (Object)"wA==")});
    }

    @SafeVarargs
    private final void assertConfigMapContainsData(ConfigMap configMap, MapEntry<String, String> ... mapEntries) {
        ((MapAssert)Assertions.assertThat((Object)configMap).extracting(ConfigMap::getData).asInstanceOf(InstanceOfAssertFactories.MAP)).contains(mapEntries);
    }

    private MapEntry<String, String> createExpectedEntry(String key, Path filePath) throws IOException {
        String fileContent = new String(Files.readAllBytes(filePath));
        return Assertions.entry((Object)key, (Object)fileContent);
    }
}

