/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.StandardHttpClient;
import io.fabric8.kubernetes.client.http.StandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.StandardWebSocketBuilder;
import io.fabric8.kubernetes.client.http.TestAsyncBody;
import io.fabric8.kubernetes.client.http.TestHttpResponse;
import io.fabric8.kubernetes.client.http.TestStandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.TestStandardHttpClientFactory;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opentest4j.AssertionFailedError;

public class TestStandardHttpClient
extends StandardHttpClient<TestStandardHttpClient, TestStandardHttpClientFactory, TestStandardHttpClientBuilder> {
    private final Map<String, Expectation> expectations = new HashMap<String, Expectation>();
    private final List<RecordedBuildWebSocketDirect> recordedBuildWebSocketDirects = new ArrayList<RecordedBuildWebSocketDirect>();
    private final List<RecordedConsumeBytesDirect> recordedConsumeBytesDirects = new ArrayList<RecordedConsumeBytesDirect>();

    protected TestStandardHttpClient(TestStandardHttpClientBuilder builder, AtomicBoolean closed) {
        super((StandardHttpClientBuilder)builder, closed);
    }

    public void doClose() {
        this.recordedConsumeBytesDirects.clear();
        this.recordedBuildWebSocketDirects.clear();
        this.expectations.values().forEach(e -> {
            ((Expectation)e).futures.clear();
            ((Expectation)e).wsFutures.clear();
        });
        this.expectations.clear();
    }

    public synchronized CompletableFuture<WebSocketResponse> buildWebSocketDirect(StandardWebSocketBuilder standardWebSocketBuilder, WebSocket.Listener listener) {
        CompletableFuture<WebSocketResponse> future;
        try {
            future = ((WsFutureProvider)this.find(standardWebSocketBuilder.asHttpRequest().uri()).wsFutures.poll()).get(standardWebSocketBuilder, listener);
        }
        catch (Exception e) {
            throw new AssertionFailedError("Unexpected exception", (Throwable)e);
        }
        this.recordedBuildWebSocketDirects.add(new RecordedBuildWebSocketDirect(standardWebSocketBuilder, listener, future));
        return future;
    }

    public synchronized CompletableFuture<HttpResponse<AsyncBody>> consumeBytesDirect(StandardHttpRequest request, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
        CompletableFuture<HttpResponse<AsyncBody>> future;
        try {
            future = ((FutureProvider)this.find(request.uri()).futures.poll()).get(request, consumer);
        }
        catch (Exception e) {
            throw new AssertionFailedError("Unexpected exception", (Throwable)e);
        }
        this.recordedConsumeBytesDirects.add(new RecordedConsumeBytesDirect(request, consumer, future));
        return future;
    }

    public TestStandardHttpClientBuilder newBuilder() {
        return (TestStandardHttpClientBuilder)super.newBuilder();
    }

    private Expectation find(URI uri) {
        String path = uri.getPath();
        for (Map.Entry<String, Expectation> e : this.expectations.entrySet()) {
            if (!path.matches(e.getKey())) continue;
            return e.getValue();
        }
        throw new AssertionFailedError("Missing expectation for path: " + path);
    }

    public final TestStandardHttpClient expect(String pathRegex, Throwable exception) {
        CompletableFuture<HttpResponse<AsyncBody>> future = new CompletableFuture<HttpResponse<AsyncBody>>();
        future.completeExceptionally(exception);
        return this.expect(pathRegex, future);
    }

    public final TestStandardHttpClient wsExpect(String pathRegex, WebSocketResponse webSocketResponse) {
        return this.wsExpect(pathRegex, CompletableFuture.completedFuture(webSocketResponse));
    }

    public final TestStandardHttpClient expect(String pathRegex, HttpResponse<AsyncBody> response) {
        return this.expect(pathRegex, CompletableFuture.completedFuture(response));
    }

    public final TestStandardHttpClient wsExpect(String pathRegex, CompletableFuture<WebSocketResponse> future) {
        return this.wsExpect(pathRegex, (StandardWebSocketBuilder s, WebSocket.Listener l) -> future);
    }

    public final TestStandardHttpClient expect(String pathRegex, CompletableFuture<HttpResponse<AsyncBody>> future) {
        return this.expect(pathRegex, (StandardHttpRequest r, AsyncBody.Consumer<List<ByteBuffer>> c) -> future);
    }

    public final TestStandardHttpClient wsExpect(String pathRegex, WsFutureProvider wsFuture) {
        Expectation expectation = this.expectations.compute(pathRegex, (k, v) -> v == null ? new Expectation() : v);
        expectation.wsFutures.add(wsFuture);
        return this;
    }

    public final TestStandardHttpClient expect(String pathRegex, int statusCode) {
        return this.expect(pathRegex, statusCode, (byte[])null);
    }

    public final TestStandardHttpClient expect(String pathRegex, int statusCode, String body) {
        return this.expect(pathRegex, statusCode, body.getBytes(StandardCharsets.UTF_8));
    }

    public final TestStandardHttpClient expect(String pathRegex, int statusCode, byte[] body) {
        Expectation expectation = this.expectations.compute(pathRegex, (k, v) -> v == null ? new Expectation() : v);
        expectation.futures.add((r, c) -> {
            TestAsyncBody asyncBody = new TestAsyncBody();
            if (body != null) {
                c.consume(Collections.singletonList(ByteBuffer.wrap(body)), (AsyncBody)asyncBody);
            }
            return CompletableFuture.completedFuture(new TestHttpResponse().withCode(statusCode).withBody(asyncBody));
        });
        return this;
    }

    public final TestStandardHttpClient expect(String pathRegex, FutureProvider future) {
        Expectation expectation = this.expectations.compute(pathRegex, (k, v) -> v == null ? new Expectation() : v);
        expectation.futures.add(future);
        return this;
    }

    public List<RecordedBuildWebSocketDirect> getRecordedBuildWebSocketDirects() {
        return this.recordedBuildWebSocketDirects;
    }

    public List<RecordedConsumeBytesDirect> getRecordedConsumeBytesDirects() {
        return this.recordedConsumeBytesDirects;
    }

    public static final class RecordedConsumeBytesDirect {
        private final StandardHttpRequest request;
        private final AsyncBody.Consumer<List<ByteBuffer>> consumer;
        private final CompletableFuture<HttpResponse<AsyncBody>> future;

        public RecordedConsumeBytesDirect(StandardHttpRequest request, AsyncBody.Consumer<List<ByteBuffer>> consumer, CompletableFuture<HttpResponse<AsyncBody>> future) {
            this.request = request;
            this.consumer = consumer;
            this.future = future;
        }

        public StandardHttpRequest getRequest() {
            return this.request;
        }

        public AsyncBody.Consumer<List<ByteBuffer>> getConsumer() {
            return this.consumer;
        }

        public CompletableFuture<HttpResponse<AsyncBody>> getFuture() {
            return this.future;
        }
    }

    public static final class RecordedBuildWebSocketDirect {
        private final StandardWebSocketBuilder standardWebSocketBuilder;
        private final WebSocket.Listener listener;
        private final CompletableFuture<WebSocketResponse> future;

        public RecordedBuildWebSocketDirect(StandardWebSocketBuilder standardWebSocketBuilder, WebSocket.Listener listener, CompletableFuture<WebSocketResponse> future) {
            this.standardWebSocketBuilder = standardWebSocketBuilder;
            this.listener = listener;
            this.future = future;
        }

        public StandardWebSocketBuilder getStandardWebSocketBuilder() {
            return this.standardWebSocketBuilder;
        }

        public WebSocket.Listener getListener() {
            return this.listener;
        }

        public CompletableFuture<WebSocketResponse> getFuture() {
            return this.future;
        }
    }

    public static final class Expectation {
        private final ConcurrentLinkedQueue<WsFutureProvider> wsFutures = new ConcurrentLinkedQueue();
        private final ConcurrentLinkedQueue<FutureProvider> futures = new ConcurrentLinkedQueue();
    }

    @FunctionalInterface
    public static interface FutureProvider {
        public CompletableFuture<HttpResponse<AsyncBody>> get(StandardHttpRequest var1, AsyncBody.Consumer<List<ByteBuffer>> var2) throws Exception;
    }

    @FunctionalInterface
    public static interface WsFutureProvider {
        public CompletableFuture<WebSocketResponse> get(StandardWebSocketBuilder var1, WebSocket.Listener var2) throws Exception;
    }
}

