/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.TestStandardHttpClient;
import io.fabric8.kubernetes.client.http.TestStandardHttpClientBuilder;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class TestStandardHttpClientFactory
implements HttpClient.Factory {
    private final ConcurrentLinkedQueue<TestStandardHttpClient> instances = new ConcurrentLinkedQueue();

    public TestStandardHttpClientBuilder newBuilder() {
        return new TestStandardHttpClientBuilder(this, this.instances);
    }

    public final TestStandardHttpClient getInstance(int index) {
        return this.instances.toArray(new TestStandardHttpClient[0])[index];
    }

    public final Stream<TestStandardHttpClientFactory> times(int iterations) {
        return IntStream.range(0, iterations).mapToObj(i -> this);
    }

    public final void expect(String pathRegex, int statusCode) {
        this.instances.forEach(c -> c.expect(pathRegex, statusCode));
    }

    public final void expect(String pathRegex, int statusCode, String body) {
        this.instances.forEach(c -> c.expect(pathRegex, statusCode, body));
    }

    public final void expect(String pathRegex, int statusCode, byte[] body) {
        this.instances.forEach(c -> c.expect(pathRegex, statusCode, body));
    }

    public ConcurrentLinkedQueue<TestStandardHttpClient> getInstances() {
        return this.instances;
    }
}

