/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpHeaders;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.utils.IOHelpers;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class StandardHttpRequestTest {
    StandardHttpRequestTest() {
    }

    @Test
    void builderMethod() {
        HttpRequest.Builder b = ((StandardHttpRequest.Builder)((StandardHttpRequest.Builder)new StandardHttpRequest.Builder().header("h1", "v1")).header("h1", "v2")).uri("https://example.com/aitana").expectContinue().method("PUT", "application/json", "{\"v\":true}");
        HttpRequest result = b.build();
        ((MapAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isInstanceOf(StandardHttpRequest.class)).returns((Object)URI.create("https://example.com/aitana"), HttpRequest::uri)).returns((Object)"PUT", HttpRequest::method)).returns((Object)"{\"v\":true}", HttpRequest::bodyString)).extracting(HttpHeaders::headers, InstanceOfAssertFactories.map(String.class, List.class))).containsOnly(new Map.Entry[]{Assertions.entry((Object)"h1", Arrays.asList("v1", "v2")), Assertions.entry((Object)"Content-Type", Collections.singletonList("application/json")), Assertions.entry((Object)"Expect", Collections.singletonList("100-Continue"))});
    }

    @Test
    void builderPostBytes() {
        HttpRequest.Builder b = new StandardHttpRequest.Builder().uri("https://example.com/alex").post("text/plain", "The bytes".getBytes(StandardCharsets.UTF_8));
        HttpRequest result = b.build();
        ((MapAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isInstanceOf(StandardHttpRequest.class)).asInstanceOf(InstanceOfAssertFactories.type(StandardHttpRequest.class))).returns((Object)URI.create("https://example.com/alex"), HttpRequest::uri)).returns((Object)"POST", HttpRequest::method)).returns((Object)"The bytes", r -> StandardHttpRequestTest.toString(r.bodyStream()))).extracting(HttpHeaders::headers, InstanceOfAssertFactories.map(String.class, List.class))).containsOnly(new Map.Entry[]{Assertions.entry((Object)"Content-Type", Collections.singletonList("text/plain")), Assertions.entry((Object)"Content-Length", Collections.singletonList("9"))});
    }

    @Test
    void toBuilderReturnsNewBuilderWithPreservedSettings() {
        HttpRequest.Builder b = ((StandardHttpRequest.Builder)new StandardHttpRequest.Builder().header("h1", "v1")).uri("https://example.com/julia");
        StandardHttpRequest.Builder result = ((StandardHttpRequest)b.build()).toBuilder();
        ((MapAssert)((AbstractObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isNotSameAs((Object)b)).extracting(HttpRequest.Builder::build).isInstanceOf(StandardHttpRequest.class)).returns((Object)URI.create("https://example.com/julia"), HttpRequest::uri).returns((Object)"GET", HttpRequest::method).extracting(HttpHeaders::headers, InstanceOfAssertFactories.map(String.class, List.class))).containsOnly(new Map.Entry[]{Assertions.entry((Object)"h1", Collections.singletonList("v1"))});
    }

    static String toString(InputStream is) {
        try {
            return IOHelpers.readFully((InputStream)is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

