/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.mockwebserver.DefaultMockServer;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public abstract class AbstractAsyncBodyTest {
    private static DefaultMockServer server;

    @BeforeAll
    static void beforeAll() {
        server = new DefaultMockServer(false);
        server.start();
    }

    @AfterAll
    static void afterAll() {
        server.shutdown();
    }

    protected abstract HttpClient.Factory getHttpClientFactory();

    @Test
    @DisplayName(value="Lines are processed and consumed only after the consume() invocation")
    public void consumeLinesProcessedAfterConsume() throws Exception {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/consume-lines")).andReturn(200, (Object)"This is the response body\n")).always();
            StringBuffer responseText = new StringBuffer();
            HttpResponse asyncBodyResponse = (HttpResponse)client.consumeLines(client.newHttpRequestBuilder().uri(server.url("/consume-lines")).build(), (value, asyncBody) -> {
                responseText.append((String)value);
                asyncBody.consume();
            }).get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((StringBuffer)responseText).isEmpty();
            ((HttpClient.AsyncBody)asyncBodyResponse.body()).consume();
            ((HttpClient.AsyncBody)asyncBodyResponse.body()).done().get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((StringBuffer)responseText).contains(new CharSequence[]{"This is the response body"});
        }
    }

    @Test
    @DisplayName(value="Lines are not processed when cancel() invocation")
    public void consumeLinesNotProcessedIfCancelled() throws Exception {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/cancel")).andReturn(200, (Object)"This would be the response body")).always();
            StringBuffer responseText = new StringBuffer();
            HttpResponse asyncBodyResponse = (HttpResponse)client.consumeLines(client.newHttpRequestBuilder().uri(server.url("/cancel")).build(), (value, asyncBody) -> {
                responseText.append((String)value);
                asyncBody.consume();
            }).get(10L, TimeUnit.SECONDS);
            ((HttpClient.AsyncBody)asyncBodyResponse.body()).cancel();
            ((HttpClient.AsyncBody)asyncBodyResponse.body()).consume();
            CompletableFuture doneFuture = ((HttpClient.AsyncBody)asyncBodyResponse.body()).done();
            org.junit.jupiter.api.Assertions.assertThrows(CancellationException.class, () -> {
                Void cfr_ignored_0 = (Void)doneFuture.get(10L, TimeUnit.SECONDS);
            });
            Assertions.assertThat((StringBuffer)responseText).isEmpty();
        }
    }

    @Test
    @DisplayName(value="Bytes are processed and consumed only after the consume() invocation")
    public void consumeByteBufferLinesProcessedAfterConsume() throws Exception {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/consume-bytes")).andReturn(200, (Object)"This is the response body as bytes")).always();
            StringBuffer responseText = new StringBuffer();
            HttpResponse asyncBodyResponse = (HttpResponse)client.consumeBytes(client.newHttpRequestBuilder().uri(server.url("/consume-bytes")).build(), (value, asyncBody) -> {
                responseText.append(value.stream().map(StandardCharsets.UTF_8::decode).map(CharBuffer::toString).collect(Collectors.joining()));
                asyncBody.consume();
            }).get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((StringBuffer)responseText).isEmpty();
            ((HttpClient.AsyncBody)asyncBodyResponse.body()).consume();
            ((HttpClient.AsyncBody)asyncBodyResponse.body()).done().get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((StringBuffer)responseText).contains(new CharSequence[]{"This is the response body as bytes"});
        }
    }
}

